package PP_VCS_Base;

use strict;
use warnings;
use Carp;
use File::Basename;
use pp_build_lib;

sub create_checksum {
    my $self = shift;

    # (we could use Digest:MD5 but, this will require some more LoC)
    my $b_dir = "build_sys";
    my $md5cmd = qq(md5sum $b_dir/ppvcs.pl $b_dir/pp_build_lib.pm )
	    . qq($b_dir/pp_hw_data.pm $b_dir/PP_VCS.pm )
	    . qq($b_dir/PP_VCS_Base.pm $b_dir/PP_VCS_CVS.pm )
	    . qq($b_dir/PP_VCS_SVN.pm > ppvcs.md5);

    system ($md5cmd);
}


sub verify_checksum {
    my $self = shift;

    if (-r "ppvcs.md5") {
	system ("md5sum -c ppvcs.md5 > /dev/null 2>&1");
	return $?;
    }
    else {
	die "Cannot verify integrity! Checksum file does not exist.";
    }
}


sub read_target_config {
    my $self = shift;

    # is expected to fail silently if config file
    # does not exist
    if (open my $fh, $build_fw_target_cfg_file) {
        my $cnt = 0;
        my $error = 0;
        my $errmsg = "";
        print "\nReading build target configuration file: ";
        while (<$fh>) {
            $cnt++;
            $_ =~ /#.*/ and next;
            $_ =~ /^$/ and next;
            $_ =~ /^(\s*[^=]+?)\s*=\s*(.*?)\s*$/;
            if (defined($1) and defined($2)) {
                if ($1 eq "fw_type") {
                    $self->{target_config}{"fw_type"} = $2;
                } elsif ($1 eq "board") {
                    $self->{target_config}{"board"} = $2;
                } elsif ($1 eq "subboard") {
                    $self->{target_config}{"subboard"} = $2;
                } elsif ($1 eq "product") {
                    $self->{target_config}{"product"} = $2;
                } elsif ($1 eq "oem") {
                    $self->{target_config}{"oem"} = $2;
                } elsif ($1 eq "lightoem") {
                    $self->{target_config}{"lightoem"} = $2;
                } elsif ($1 eq "build_type") {
                    $self->{target_config}{"build_type"} = $2;
                } elsif ($1 eq "preserve_install_root") {
                    $self->{target_config}{"preserve_install_root"} = $2;
                } else {
                    $error = 1;
                    $errmsg .= "$build_fw_target_cfg_file: Invalid line $cnt\n";                }
            }
        }
        close $fh;
        if ($error) {
            print "failed\n";
            die "\n$errmsg\n\n";
        } else {
            print "done\n";
        }
    }
}


sub write_target_config {
    my $self = shift;
    my $targetfh;
    # write target configuration file
    print "\nWriting build target configuration file: ";
    if (!open $targetfh, ">$build_fw_target_cfg_file") {
        print "failed\n";
        die "\nCannot open '$build_fw_target_cfg_file' for writing ($!)\n\n";
    }

    print $targetfh <<EOF;
###############################################################################
# This file determines for which target the firmware will be build
#
# ATTENTION: DO NOT EDIT THIS FILE! IT IS CREATED AUTOMATICALLY.
#

fw_type = $self->{target_config}{"fw_type"}
board = $self->{target_config}{"board"}
subboard = $self->{target_config}{"subboard"}
product = $self->{target_config}{"product"}
oem = $self->{target_config}{"oem"}
lightoem = $self->{target_config}{"lightoem"}
build_type = $self->{target_config}{"build_type"}
EOF
    close $targetfh;
    print "done\n\n";
}


sub print_target_config {
    my $self = shift;

    # print the target configuration
    print "---- Configuration --------------------------------------\n";
    if ($self->{vcs}{mode} eq 'CVS') {
	print "Repo Tag      : " . ($self->{vcs}{tag} ne "" ? $self->{vcs}{tag} : "MAIN") . "\n";
    } else {
	print "Repo Tag      : " . $self->{vcs}{path} . "\n";
    }
    print "Firmware type : " . $self->{target_config}{"fw_type"} . "\n";
    print "Board         : " . $self->{target_config}{"board"} . "\n";
    print "Sub-board     : " . $self->{target_config}{"subboard"} . "\n";
    print "Product       : " . $self->{target_config}{"product"} . "\n";
    print "OEM           : " . $self->{target_config}{"oem"} . "\n";
    print "Light-OEM     : " . $self->{target_config}{"lightoem"} . "\n";
    print "Build type    : " . $self->{target_config}{"build_type"} . "\n";
    print "---------------------------------------------------------\n\n";
}


sub generate_config_sh_mk {
    my $self = shift;

    # we need Config.sh, generated by build system. generate fake if it
    # isn't there
    my $PP_BUILD_SYS_DIR = dirname($0);
    if($PP_BUILD_SYS_DIR) {
	$PP_BUILD_SYS_DIR .= "/";
    }
    my $Configsh .= "Config.sh";
    if ( ! -e $Configsh or $self->{options}{reconf_view} ) {
	open(my $fh, ">$Configsh") or die "\nCannot open $Configsh for writing ($!).\n\n";
	print $fh "PP_FW_TYPE=\"" . $self->{target_config}{"fw_type"} . "\"\n";
	print $fh "PP_BOARD=\"" . $self->{target_config}{"board"} . "\"\n";
	print $fh "PP_SUBBOARD=\"" . $self->{target_config}{"subboard"} . "\"\n";
	print $fh "PP_PRODUCT=\"" . $self->{target_config}{"product"} . "\"\n";
	print $fh "PP_OEM=\"" . $self->{target_config}{"oem"} . "\"\n";
	print $fh "PP_BUILD_TYPE=\"" . $self->{target_config}{"build_type"} . "\"\n";
	print $fh "source $PP_BUILD_SYS_DIR/Build.inc.sh\n";
	print $fh "[ -f $PP_BUILD_SYS_DIR/../pp_features.sh ] && source $PP_BUILD_SYS_DIR/../pp_features.sh\n";

	close $fh;
    }

    my $Configmk .= "Config.mk";
    if ( ! -e $Configmk or $self->{options}{reconf_view} ) {
	open(my $fh, ">$Configmk") or die "\nCannot open $Configmk for writing ($!).\n\n";
	print $fh "-include $PP_BUILD_SYS_DIR/../pp_features.mk\n";
	print $fh "PP_BUILD_SYS_DIR=$PP_BUILD_SYS_DIR\n";
	close $fh;
    }
}

sub debug {
    my $self = shift;

    # get
    unless (@_ == 1 ) {
        if (ref($self)) {
            return $self->{_DEBUG};
        }
        else {
            confess "You cannot use this as a class method!";
        }
    }

    # set
    my $level = shift;

    if (ref($self)) {
	    # set debugging level
	    $self->{_DEBUG} = $level;
    }
    else {
        confess "You need an object here!";
    }
}


sub use_log_file {
    my $self = shift;

    # get
    unless (@_ == 1 ) {
	if (ref($self)) {
	    return $self->{_USE_LOGFILE};
	}
	else {
	    confess "You cannot use this as a class method!";
	}
    }

    # set
    my $arg = shift;

    if (ref($self)) {
	$self->{_USE_LOGFILE} = $arg;
    }
    else {
	confess "You need an object here!";
    }
}


sub do_log {
    my $self = shift;
    my $level = shift;
    my $logmessage = shift;
    my $timestr = "[" . scalar localtime() . "] ";

    if ( $self->debug >= $level ) {
	if ( $self->use_log_file ) {
	    my $logfile = 'cvs.log';
	    my $fh;
	    open ($fh, ">>$logfile") or
		croak "Error opening logfile $logfile";
	    print $fh "$logmessage";
	    close ($fh);
	}
	else {
	    if ( $level == $DEBUG{ERROR} ) {
		print STDERR $logmessage;
	    }
	    else {
		print STDOUT $logmessage;
	    }
	}
    }

    if ( $level == $DEBUG{ERROR} ) {
	confess "ppvcs ERROR: $logmessage";
    }
}

1;
