# !/usr/bin/env python
# -*- coding: ISO8859-15 -*-
#
# (C) 2004-2005 Peppercon AG, Zwickau (Sachs)
# Frank Hofmann <fho@peppercon.de>
#
# docbook optimizer
# Python script to prepare selected documentation file
#
# updated 2005-09-05
#
# libraries and modules
import xml.dom.minidom
import sys
import string
import os
import re

import standard

# function:
# substitute entities by their defined value

# read and verify parameters --------------------

# read from parameter 1
inputFile = sys.argv[1]
outputFile = sys.argv[2]

# read from input file into array
print "reading input file: " + inputFile
inputFileContentArray = standard.readFileContent (inputFile)
pattern = re.compile(u'ENTITY\s+(\w+)\s+\"(.+)\"', re.UNICODE)

print len(inputFileContentArray)
entityList = []
for line in inputFileContentArray:
	newEntity = re.findall(pattern, line)
	if newEntity != []:
		entityList.append(newEntity)

print entityList

output = ""
for line in inputFileContentArray:
	for newEntity in entityList:
		oldEntity = re.compile('<' + newEntity[0][0] + '/>', re.UNICODE)
		substitution = newEntity[0][1]

		line = re.sub(oldEntity, substitution, line)
	output += line
	
outputFileContentArray = [output]

# save output file ------------------------------
if standard.saveFileContent (outputFile, outputFileContentArray) == 0:
	print "... entities successfully substituted"
else:
	print "Cannot save output to file ", outputFile
	sys.exit(1)

print ""
