#!/bin/bash

# renice (default 10)
renice ${PP_BUILD_NICE:-10} -p $$ > /dev/null

# extract fw_topdir since the later used $* is not save when spaces
# occure in fw_topdir
fw_topdir=$1
shift

BUILD_LOG="$fw_topdir/build.log"
MAX_BUILD_LOGS=${PP_MAX_BUILD_LOGS:-4}

# rotate log files
let i=${MAX_BUILD_LOGS}-1
while [ $i -gt 0 ]; do
    let j=$i-1
    if [ "$j" != "0" ]; then
	[ -r "${BUILD_LOG}.$j" ] && mv "${BUILD_LOG}.$j" "${BUILD_LOG}.$i"
    else
	[ -r "${BUILD_LOG}" ] && mv "${BUILD_LOG}" "${BUILD_LOG}.$i"
    fi
    i=$j
done

if [ "`uname | cut -b 1-6`" != "CYGWIN" ]; then

	# compile script.c if necessary
	gcc -Wall -W -O2 -fomit-frame-pointer -o "$fw_topdir/build_sys/script" "$fw_topdir/build_sys/script.c" -lutil || exit 1

	# start logged build (the sleep is necessary else we miss the end sometimes!)
	exec "$fw_topdir/build_sys/script" -q -c "$fw_topdir/build_sys/build_fw.pl '$fw_topdir' $*; exitcode=\$?; sleep 1; exit \$exitcode" "${BUILD_LOG}"
else
	# start logged build (the sleep is necessary else we miss the end sometimes!)
	"$fw_topdir/build_sys/build_fw.pl" "$fw_topdir" "$@" 2>&1 | tee "${BUILD_LOG}"
fi
