#!/bin/sh

. Config.sh

TAR_EXCLUDES="$PWD/tar-EXCLUDES"

cleanup() {
    rm -f "${TAR_EXCLUDES}"
}

trap cleanup EXIT

# check if in software SDK
IN_SDK=no
if grep in_sdk build_fw_target.cfg ; then IN_SDK=yes ; fi

# strip binaries
for f in `find install_root_final/ -type f \( -perm -0100 -or -perm -0010 -or -perm -0001 \) -exec file {} \; | \
	    grep ' executable,' | sed -n -e 's/^\(.*\):[  ]*ELF.*,.*stripped/\1/p'`; do
    command="${CROSS}strip -R .note -R .comment $f"
    echo $command
    eval $command
done

# strip shared libraries
for f in `find install_root_final/ -type f -a -exec file {} \; | \
	    grep ' shared object,' | sed -n -e 's/^\(.*\):[  ]*ELF.*,.*stripped/\1/p'`; do
    command="${CROSS}strip -R .note -R .comment $f"
    echo $command
    eval $command
done

if [ "$PP_FEAT_FILES_TO_FLASHDISK" = "1" ] ; then
    echo Copying some resources to flashdisk/oem and generate oem_flashdisk_files.tgz

    # to save space in the init fs, some Web resources have to be moved to the flashdisk partition
    # this includes: applet, images, etc.
    # the flashdisk partion is packed to oem_flashdisk_files.tgz and mus be added to the firmware binary
    mkdir -p install_root_final/flashdisk/oem/webpages
    mv -f install_root_final/lib/webpages/*.jar install_root_final/flashdisk/oem/webpages/
    mv -f install_root_final/lib/webpages/*.dll install_root_final/flashdisk/oem/webpages/
    mv -f install_root_final/lib/webpages/*.gif install_root_final/flashdisk/oem/webpages/
    #mv -f install_root_final/lib/webpages/*.jpg install_root_final/flashdisk/oem/webpages/
    #mv -f install_root_final/lib/webpages/MIB.txt install_root_final/flashdisk/oem/webpages/

    # create oem_flashdisk_files.tgz
    rm -f mkfirmware/oem_flashdisk_files.tgz
    tar -czf mkfirmware/oem_flashdisk_files.tgz -C install_root_final/flashdisk/oem webpages/

    # copy all that stuff also to mkfirmware/oem_template to have it in the OEM SDK as well
    cp -r install_root_final/flashdisk/oem/* mkfirmware/oem_template/
fi

# erla specific finalize actions
if [ "$PP_FW_TYPE" = "erla" ]; then
    if [ "$IN_SDK" = "no" ]; then

	if [ "$PP_FEAT_JFFS2_ROOTFS" = "1" ]; then
	    # create list of files that we do not want in the final firmware
	    rm -f "$TAR_EXCLUDES"
	    cd install_root_final && {
		find . -name "*.a" >> "$TAR_EXCLUDES" || exit 1
		find . -name "*.la" >> "$TAR_EXCLUDES" || exit 1
		find . -name "*.so" \
		  -exec /bin/sh -c '(file -L {} | grep -q "shared object") || echo {}' \; \
		  >> "$TAR_EXCLUDES" || exit 1
                if [ -e share ] ; then
                    find share -maxdepth 1 -name aclocal\* -o -name autoconf\* -o -name automake\* -o -name libtool\* >> "$TAR_EXCLUDES" || exit 1
                fi
		sed -i 's,^\./,,' "$TAR_EXCLUDES" || exit 1
		cd -
	    } || exit 1
	    echo ---- Excluding the following files ----
	    cat "$TAR_EXCLUDES"
	    echo ---------------------------------------
	    tar -C install_root_final --exclude-from "$TAR_EXCLUDES" -czf $FW_TOPDIR/mkfirmware/rootfs.tgz . || exit 1
	else
	    # create the ram disk image
	    pushd mkfirmware
	    # support creating the image on machines where we 
	    # don't have unlimited sudo permissions (namely 'hal')
	    if [ -x "/usr/local/bin/make_initrd_image" ]; then
		sudo /usr/local/bin/make_initrd_image || exit 1
	    else
		sudo ./make_image || exit 1
	    fi
	    popd
	fi

        # zip flashdisk parts
        pushd flash_root/
        for d in `find . -maxdepth 1 -type d `; do
            if [ "$d" = "." -o "$d" = ".." ]; then continue; fi
                tar -C $d -czf $d.tgz .
            if [ "$?" != "0" ]; then
                echo "$0: error building flash part $d"	
            fi
            cp -f $d.tgz "$FW_TOPDIR/mkfirmware"
        done
        popd
    else
        # we're in SDK mode, update the firmware image of this sdk with the new binaries
	if [ "$PP_FEAT_JFFS2_ROOTFS" = "1" ]; then
	    echo "TODO: finalize in SDK mode NOT IMPLEMENTED"
	    exit 1
	else
	    # get firmware image name
	    fw_filename=`ls rtsys/ | grep "fw.*\.bin"`
	    if [ "$fw_filename" = "" ]; then
		echo "ERROR: Could not update firmware binary, file not found"
		exit 1
	    fi

	    pushd mkfirmware/
	    cp ../rtsys/$fw_filename .
	    ./update_firmware $fw_filename
            if [ $? != "0" ]; then
                popd
                exit 1;
            fi

	    if [ "$PP_FEAT_FILES_TO_FLASHDISK" = "1" ] ; then 
                # add/replace oem_part with oem.tgz
                ./replacepart.pl -a oem_flashdisk_files.tgz -p 4 -s 0 $fw_filename
            fi
	    
	    popd

	    echo Firmware file has been updated, new firmware file is ./mkfirmware/$fw_filename
	fi
    fi
fi
