include Config.mk

ifeq ($(IN_SDK), 1)
FW_DEFINES += -DPP_FEAT_IN_SDK=1
endif

all: pp_features.h pp_features.mk pp_features.sh

pp_features.h: FORCE
	rm -f $@.new
	echo "/* automatically generated by build_fw.pl */" > $@.new
	echo "#ifndef _PP_FEATURES_H" >> $@.new
	echo "#define _PP_FEATURES_H" >> $@.new
	echo >> $@.new
	if [ -f "build_sys/features.$(PP_FW_TYPE).h" ]; then \
	    gcc $(FW_DEFINES) -E -dM "build_sys/features.$(PP_FW_TYPE).h" \
		| grep '#define PP_FEAT' \
		| sort -u >> $@.new; \
	    if [ "$${PIPESTATUS[*]}" != "0 0 0" -a "$${PIPESTATUS[*]}" != "0 1 0" ]; then \
		exit 1; \
	    fi \
	fi
	echo >> $@.new
	echo "#endif /* !_PP_FEATURES_H */" >> $@.new
	if cmp -s $@.new $@; then \
	    rm -f $@.new; \
	else \
	    rm -f $@.h; \
	    mv -f $@.new $@; \
	fi
	mkdir -p include/pp
	rm -f include/pp/features.h
	ln -s ../../pp_features.h include/pp/features.h

pp_features.mk pp_features.sh: pp_features.h
	echo "# automatically generated by build_fw.pl" > $@
	if [ -f include/pp/features.h ]; then \
	    gcc $(FW_DEFINES) -E -dM pp_features.h \
		| grep '#define PP_FEAT' \
		| sort -u \
		| gawk '{ print $$2 "=" $$3 }' >> $@; \
	fi

clean:
	@rm -f pp_features.h pp_features.mk pp_features.sh

FORCE:
