###############################################################################
#
# pp_build_lib - some build system routines
#

package pp_build_lib;

use strict;

use vars qw(
            @ISA
            @EXPORT
	    $build_fw_target_cfg_file
	    @alltags
	    @build_types
	    %DEBUG
           );

#
###############################################################################
# imports

use FindBin;
use lib "$FindBin::Bin";

use pp_hw_data;

%DEBUG = (
    'NONE'      => 0,
    'ERROR'     => 1,
    'WARN'      => 2,
    'NOTICE'    => 3,
    'INFO'      => 4,
    'DEBUG'     => 5,
    'VERBOSE'   => 6,
    'ALL'       => 7,
);


#
###############################################################################
# global variables

my $build_fw_cfg_file_pattern = "build_sys/build_fw.#fw_type#.cfg";
my $build_fw_cfg_file_fallback = "build_fw.cfg";
$build_fw_target_cfg_file = "build_fw_target.cfg";
@alltags = ( "none", "nobuild" );
@build_types = ("debug", "debugopt", "dmalloc", "profile", "devel", "final");

#
###############################################################################
# subroutines

sub get_components ( $$$$$$$$ ) {
    my $all_components = shift;
    my $components = shift;
    my $skip_missing_dirs = shift;
    my $fw_type = shift;
    my $board = shift;
    my $subboard = shift;
    my $product = shift;
    my $tag = shift;

    # determine build config file
    my $build_fw_cfg_file;
    if ( -f $build_fw_cfg_file_fallback ) {
	# fallback for eric_firmware
	$build_fw_cfg_file = $build_fw_cfg_file_fallback;
    } else {
	$build_fw_cfg_file = $build_fw_cfg_file_pattern;
	$build_fw_cfg_file =~ s/#fw_type#/$fw_type/;
    }

    # construct some regex that are used later
    my $allproducts  = {};
    my $allsubboards = {};
    my $allproducts_rx = "";
    my $allsubboards_rx = "";
    my $alltags_rx = "";
    foreach my $_board (keys %{$hw_id_map->{$fw_type}}) {
	foreach my $_subboard (keys %{$hw_id_map->{$fw_type}->{$_board}}) {
	    foreach my $_product (keys %{$hw_id_map->{$fw_type}->{$_board}->{$_subboard}}) {
		defined($allproducts->{$_product}) and next;
		$allproducts->{$_product} = 1;
		$allproducts_rx .= "|$_product";
	    }
	    defined($allsubboards->{$_subboard}) and next;
	    $allsubboards->{$_subboard} = 1;
	    $allsubboards_rx .= "|$_subboard";
	}
    }
    foreach my $_tag (@alltags) {
	$alltags_rx .= "|$_tag";
    }
    $allproducts_rx  =~ s/^(.*)$/(common$1)/;
    $allsubboards_rx =~ s/^(.*)$/(common$1)/;
    $alltags_rx	 =~ s/^\|(.*)$/($1)/;

    # determine all directories that need to be build for the target
    open CFG, $build_fw_cfg_file or die "\nCannot open $build_fw_cfg_file.\n\n";
    my $line = 0;
    my $error = 0;
    while (<CFG>) {
	$line++;
	$_ =~ s/#.*//;
	chomp($_); # remove newlines
	$_ eq "" and next; # ignore empty lines
	# syntax check
	if ($_ !~ /^!?$allproducts_rx(,!?$allproducts_rx)*\|!?$allsubboards_rx(,!?$allsubboards_rx)*\|!?$alltags_rx(,$alltags_rx)*:\s*(\S+?)\s*$/) {
	    print "Parse error (line $line in $build_fw_cfg_file).\n";
	    $error++;
	    # try to match
	} elsif ($_ =~ /^[^:]+:\s*(\S+?)\s*$/) {
	    my $dir = $1;

	    # check if we want to build that package
	    # (common | included | not excluded)
	    if(($_ =~ /^([^!,|]+,)*(common|$product)(,[^,|]+)*\|.*$/ ||
		($_ =~ /^!/ && $_ !~ /^!([^,|]+,)*$product(,[^,|]+)*\|.*$/)) &&
	       ($_ =~ /^[^|]*\|([^!,|]+,)*(common|$subboard)(,[^,|]+)*\|.*$/ ||
		($_ =~ /^[^|]*\|!/ && 
		 $_ !~ /^[^|]*\|!([^,|]+,)*$subboard(,[^,|]+)*\|.*$/)) && 
	       ($_ =~ /^[^|]*\|[^|]*\|([^|]*\|)*([^!,|]+,)*$tag(,[^,:]+)*:.*$/ ||
		($_ =~ /^[^|]*\|[^|]*\|!/ && 
		 $_ !~ /^[^|]*\|[^|]*\|!([^,|]+,)*$tag(,[^,:]+)*:.*$/))) {
		if (not $skip_missing_dirs or -d $dir) {
		    push @{$components}, $dir;
		}
	    }
	    if (not $skip_missing_dirs or -d $dir) {
		push @{$all_components}, $dir;
	    }
	}
    }
    close CFG;
    # exit on error
    $error and return 0;
    return 1;
}

#
###############################################################################
# exports
#

@ISA    = qw(Exporter);
@EXPORT = qw(
	     $build_fw_target_cfg_file
	     @build_types
	     %DEBUG
	     get_components
	    );

#
###############################################################################
# Emacs
#
# Local Variables:
# cperl-indent-level:4
# cperl-continued-statement-offset:4
# cperl-continued-brace-offset:-4
# cperl-brace-offset:0
# cperl-brace-imaginary-offset:0
# cperl-label-offset:-2
# cperl-hairy:t
# perl-tab-always-indent:nil
# End:
###############################################################################
