###############################################################################
# This is a perl module containing some hardware data for peppercon products
#

package pp_hw_data;

use strict;

use vars qw(
            @ISA
            @EXPORT
	    $hw_id_map
           );

#
###############################################################################
# global variables

#
# This is the mapping table that maps board+subboard+product to a hardware id.
# The hardware id is a 2-digit hex number. "00" is used for products that don't
# have a hardware id.
#
$hw_id_map =
{
 #
 # FW Type	    Board	    Subboard	    Product	   Hardware-ID
 #
 "erla"		=> {
		    "lara"	=> {
				    "kim"	=> {
						    "eric2"		=> "0E",
						    "ericxp"		=> "0E",
						    "ericg4"		=> "0E",
						    "lara"		=> "0E",
						    "laraxp"		=> "0E",
						    "rc1"		=> "0E",
						    "0801ip"		=> "0E",
						    "1601ip"		=> "0E",
						    "smartipc"		=> "0E",
						    "ripcxn"		=> "0E",
						    "wingle"		=> "0E",
						    "flashx4"		=> "0E",
						    "ripckimxn"		=> "0E",
						    "kimtestermst"	=> "0E",
						    "lara_bmc_test"	=> "0E",
						    "icpmmd"		=> "0E",
						    "forensiccim"	=> "0E",
						   },
				    "kim16"	=> {
						    "rc1"		=> "0F",
						   },
				    "kimmsi"	=> {
						    "msidc"		=> "10",
						   },
				    "kimamd"	=> {
						    "amddc"		=> "11",
						   },
				    "kim2"	=> {
						    "ericxp"		=> "12",
						    "laraxp"		=> "12",
						    "forensiccim"	=> "12",
						   },
				    "kimsmi"	=> {
						    "smidc"		=> "13",
						   },
				    "kimintel"	=> {
						    "inteldc"		=> "14",
						   },
				    "kacy"	=> {
						    "kx2"		=> "18",
						   },
				   },
		    "kira"	=> {
				    "cpe"	=> {
						    "laraxp"		=> "15",
						    "lara"		=> "15",
						    "rc1"		=> "15",
						    "forensiccim"	=> "15",
						   },
				    "kimg4"	=> {
						    "ericg4"		=> "15",
						    "rc1"		=> "15",
						    "ericxp"		=> "15",	
						    "laraxp"		=> "15",
						    "lara"		=> "15",
						    "ericxp"            => "15",
						    "forensiccim"	=> "15",
                                                    "0801ip"            => "15",
						   },
				    "kimamdg4"	=> {
						    "amddc"		=> "20",
						   },
				    "kimasmig4"	=> {
						    "asmidc"		=> "21",
						   },
				    "kimsmig4"  => {
					    	    "smidc"		=> "22",
					           },
				    "kimrackg4" => {
						    "rackabledc"	=> "23",
						   },
				    "kimgigag4" => {
					    	    "gigadc"		=> "2C",
					           },
				    "rpc"	=> {
						    "pdu"		=> "1A",
						   },
				    "ltrxg4"	=> {
						    "laraxp"		=> "24",
						   },
				   },
		    "kxng"	=> {
				    "via"	=> {
						    "kxng"		=> "00",
						   },
				    "intel"	=> {
                                                    "kxng"              => "00",
                                                   },
				    "ati128"	=> {
                                                    "kxng"              => "00",
                                                   },
				   },
		   },
 "psetup"	=> {
		    "psetup"	=> {
				    "none"	=> {
						    "psetup"		=> "00",
						   },
				   },
		   },
 "ccf"		=> {
		    "none"	=> {
				    "none"	=> {
						    "ccf"		=> "00",
						   },
				   },
		   },
"kvmviewerlinux"=> {
		    "none"	=> {
				    "none"	=> {
						    "kvmviewerlinux"	=> "00",
						   },
				   },
		   },
"kvmviewerwin"=> {
		    "none"	=> {
				    "none"	=> {
						    "kvmviewerwin"	=> "00",
						   },
				   },
		   },
 "kiratool"	=> {
		    "none"	=> {
				    "none"	=> {
						    "kiratool"		=> "00",
						   },
				   },
		   },
 "production"	=> {
		    "lara"	=> {
				    "kim"	=> {
						    "production"	=> "0E",
						   },
				   },
		    "kira"	=> {
				    "kimg4"	=> {
						    "production"	=> "15",
						   },
				   },
		   },
 "test"		=> {
		    "none"	=> {
				    "none"	=> {
						    "test"		=> "00",
						   },
				   },
		   },
};

#
###############################################################################
# exports
#

@ISA    = qw(Exporter);
@EXPORT = qw(
	     $hw_id_map
	    );

#
###############################################################################
# Emacs
#
# Local Variables:
# cperl-indent-level:4
# cperl-continued-statement-offset:4
# cperl-continued-brace-offset:-4
# cperl-brace-offset:0
# cperl-brace-imaginary-offset:0
# cperl-label-offset:-2
# cperl-hairy:t
# perl-tab-always-indent:nil
# End:
###############################################################################
