#!/usr/bin/perl -w
#
use strict;
use warnings;

use Data::Dumper;
use FindBin;
use lib "$FindBin::Bin";

use PP_VCS;

#
###############################################################################
# main program

# save command-line parameters
@main::save_ARGV = @ARGV;

# determine the firmware root directory and change into it
my $fw_topdir = shift;
if (!defined($fw_topdir)) {
    print STDERR "\nNo firmware root directory specified!\n";
    exit 1;
} elsif (!chdir($fw_topdir)) {
    die "\nCannot change into '$fw_topdir': $!\n\n";
}

my $mode = "CVS";
if (-d "CVS") {
    $mode = "CVS";
    print "CVS mode\n";
}
elsif (-d ".svn") {
    $mode = "SVN";
    print "SVN mode\n";
}
else {
    die "I can only handle checkouts from CVS and Subversion!";
}

# instantiate VCS object
my $vc_obj = new PP_VCS($mode);
$vc_obj->determine_repo_information();
my $operation = $vc_obj->operation();
if ($operation eq 'setview') {
    # check of updates of the base
    if ($vc_obj->update_base() ) {
	# restart in case of updates
	exec $0 $0, @main::save_ARGV;
	die("\nRestarting ourself failed\n\n");
    }
}
$vc_obj->$operation();
if ($mode eq 'CVS') {
    # HACK: This commits Entries.Log to Entries
    system "cvs status dummy > /dev/null 2>&1";
}
#print Dumper $vc_obj;

