// system includes

// firmware includes
#include <pp/um.h>

// local includes
#include "cfg_conv.h"

static const char *group_acl_sec_s_key = "group[%u].acl[sec_s]";

static int convert_all_groups(void) {
    int ret = PP_SUC;
    vector_t *all_groups = pp_um_get_all_groups();
    unsigned int i, all_groups_sz = vector_size(all_groups);
    int gid;
    char *groupname;
    char *sec_s = NULL;
    
    for(i = 0; i < all_groups_sz; i++) {
        groupname = vector_get(all_groups, i);
        if ((gid = pp_um_group_get_gid(groupname)) > 0) {
            /* get old permission value */
            if (PP_FAILED(pp_cfg_get_at_layer_nodflt(PP_PROFILE_LOCAL, &sec_s,
                                                     group_acl_sec_s_key, 
                                                     gid))) {
                /* no error, simply nothing to convert for group! */
                continue;
            }
            /* set to default if no value is given */
            if (!sec_s) sec_s = strdup("no");
            /* set new permissions according to the old value */
            if (PP_FAILED(pp_cfg_set(sec_s, "group[%u].acl[auth_s]", gid)) || 
                PP_FAILED(pp_cfg_set(sec_s, "group[%u].acl[log_s]", gid)) || 
                PP_FAILED(pp_cfg_set(sec_s, "group[%u].acl[log_v]", gid)) || 
                PP_FAILED(pp_cfg_set(sec_s, "group[%u].acl[security_s]", gid))) {
                free(sec_s);
                ret = PP_ERR;
                break;
            }
            free(sec_s);
            sec_s = NULL;
            /* remove old permission */
            pp_cfg_remove(group_acl_sec_s_key, gid);
        }
    }
    vector_delete(all_groups);

    return ret;
}

int conf_split_sec_s_acl(void) {
    int ret;
    pp_cfg_tx_t *tx;
    
    /* start transaction, great deeds are to be done! */
    tx = pp_cfg_tx_begin(1);
    
    if (PP_ERR != (ret = pp_um_init())) {
        ret = convert_all_groups();

        if (ret == PP_SUC) {
            ret = pp_cfg_tx_commit(tx);
        } else {
            pp_cfg_tx_rollback(tx);
        }
    
        pp_um_cleanup();
    }

    return ret;
}
