#include <stdio.h>
#include <strings.h>
#include <bits/sockaddr.h>
#include <asm/types.h>
#include <linux/rtnetlink.h>
#include <sys/socket.h>
#include <sys/signal.h>
#include <sys/stat.h>
#include <syslog.h>
#include <errno.h>
#include <net/if.h>
#include <pp/base.h>
#include "linkwatch.h"

static int recv_reply(int fd,char *buf,size_t *len)
{
    int rtn,nll=0;

    bzero(buf, *len);
    while(1) {
	rtn = recv(fd, buf+nll, *len - nll, 0);
	if(rtn==-1)
	{
	    return -1;
	}
	nll += rtn;
	if(!(((struct nlmsghdr *)buf+nll)->nlmsg_flags & NLM_F_MULTI))
	    break;
	if(((struct nlmsghdr *)buf+nll)->nlmsg_type == NLMSG_DONE) 
	    break;
    }
    *len=nll;
    return 0;
}

static int check_reply(char *buf,size_t len)
{
    struct nlmsghdr *nlp=(struct nlmsghdr *) buf;
    for(;NLMSG_OK(nlp,len);nlp=NLMSG_NEXT(nlp,len))
    {
	switch(nlp->nlmsg_type)
	{
	    case RTM_NEWLINK:
		{
		    struct ifinfomsg *ifi=NLMSG_DATA(nlp);
		    if((ifi->ifi_flags & IFF_UP) && (ifi->ifi_flags & IFF_RUNNING))
			return 1;
		}
		break;
	    default:
		break;
	}
    }
    return 0;
}

static int nl_open(void)
{
    struct sockaddr_nl la;
    int fd;
    fd = socket(AF_NETLINK, SOCK_DGRAM, NETLINK_ROUTE);
    if(fd==-1)
    {
	return -1;
    }

    bzero(&la,sizeof(la));
    la.nl_family = AF_NETLINK;
    //la.nl_pid = getpid();
    la.nl_groups = RTMGRP_LINK;
    if(bind(fd, (struct sockaddr*) &la, sizeof(la))==-1)
    {
	return -1;
    }

    return fd;
}

int linkwatch(void)
{
    char buf[8192];
    size_t len=sizeof(buf);
    int fd;
    fd=nl_open();
    if(fd==-1)
    {
	return -1;
    }
    if(recv_reply(fd,buf,&len)==-1)
    {
	return -1;
    }
    close(fd);
    return check_reply(buf,len);
}

