#ifdef __cplusplus
extern "C" {
#endif

#include <signal.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/resource.h>
#include <sys/time.h>
#include <liberic_config.h>
#if defined(PP_FEAT_REMOTE_CONSOLE)
#include <pp/rfb.h>
#include <pp/grab.h>
#include <pp/vsc.h>
#endif /* PP_FEAT_REMOTE_CONSOLE */
#include <liberic_webs.h>
#include <liberic_session.h>
#include <liberic_notify.h>
#include <liberic_net.h>
#include <liberic_cert.h>
#include <liberic_cron.h>
#include <liberic_misc.h>
#if defined(PP_FEAT_TERMINAL_CONSOLE)
#include <liberic_term.h>
#endif /* PP_FEAT_TERMINAL_CONSOLE */
#include <pp/base.h>
#include <pp/bio.h>
#include <pp/hal.h>
#include <pp/ipc.h>
#include <pp/firmware.h>
#include <pp/setup_proto.h>
#if defined(PP_FEAT_POWERSWITCH)
#include <pp/powerswitch.h>
#endif /* PP_FEAT_POWERSWITCH */
#if defined(PP_FEAT_REMOTE_CONSOLE)
#if defined(PP_FEAT_USB)
#include <pp/usb.h>
#endif /* PP_FEAT_USB */
#include <pp/km.h>
#include <pp/kvm.h>
#endif /* PP_FEAT_REMOTE_CONSOLE */
#include <pp/um.h>
#include <pp/intl.h>
#if defined (PP_FEAT_SIMPLERFB_SUPPORT)
# include <pp/simplerfb.h>
#endif
#include <pp/serial.h>
#if defined(PP_FEAT_CIM)
#include <pp/cim.h>
#endif /* PP_FEAT_CIM */
#if defined(PP_FEAT_WS_MANAGEMENT)
# include <pp/wsman.h>
#endif /* PP_FEAT_WS_MANAGEMENT */
#include <pp/ldap_prof.h>
#include <pp/disconf.h>
#include <pp/ipmi.h>
#if defined(PP_FEAT_SSH)
#include <pp/dropbear.h>
#endif /* PP_FEAT_SSH */
#if defined(PP_FEAT_NETEVENT)
#include <pp/netevent.h>
#endif /* PP_FEAT_NETEVENT */
#include <pp/cfg.h>
/* debugging */
#if !defined(NDEBUG)
#define DBG(fmt, x...)	pp_log("eric main.c: " fmt, ##x)
#else /* NDEBUG */
#define DBG(fmt, x...)	((void)0)
#endif /* NDEBUG */

#ifdef PP_FEAT_IPMI_SERVER
#include <pp/bmc/bmc.h>
#endif /* PP_FEAT_IPMI_SERVER */

#ifdef PRODUCT_FLASHX4
#include <pp/flashprog.h>
#endif /* PRODUCT_FLASHX4 */

#ifdef PRODUCT_KX2
#include <pp/portmgr.h>
#include <pp/cim_proto_lib.h>
#include <pp/hal_kx2.h>
#endif /* PRODUCT KX2 */

#ifdef PP_FEAT_RPCCFG
#include <pp/rpc_ripc.h>
#endif /* PP_FEAT_RPCCFG */

#ifdef __cplusplus
}
#endif
#ifdef PP_FEAT_RDM_SUPPORT
#include <pp/PP_RDM.h>
#endif
#ifdef __cplusplus
extern "C" {
#endif

#define PP_GRAB_NICE	19
#ifdef OEM_TANGTOP
#define MAX_SESSIONS	15
#else    
#define MAX_SESSIONS	25
#endif

#define SESSION_TIMEOUT	1800

const char * bb_applet_name;

static int init(void);
static void postinit(void);
static void cleanup(void);

extern int eric_config_main(int argc, char ** argv);
extern int get_config_main(int argc, char ** argv);
extern int config_rtceep_main(int argc, char ** argv);
#if defined(PP_FEAT_SNMP_TRAP) || defined(PP_FEAT_NETSNMP_TRAP)
extern int snmptrap_main(int argc, char ** argv);
#endif /* PP_FEAT_SNMP_TRAP */
#if defined(PP_FEAT_SNMP_TRAPD) || defined(PP_FEAT_NETSNMP_TRAPD)
extern int snmptrapd_main(int argc, char ** argv);
#endif /* PP_FEAT_SNMP_TRAPD */
#if defined(PP_FEAT_SNMP_AGENT) || defined(PP_FEAT_NETSNMP_AGENT)
extern int snmpd_main(int argc, char ** argv);
#endif /* PP_FEAT_SNMP_AGENT */
#if defined(PP_FEAT_SSH)
extern int dropbearkey_main(int argc, char ** argv);
#endif /* PP_FEAT_SSH */
extern int dhcpcd_main(int argc, char ** argv);
extern int smbmnt_main(int argc, char ** argv);
extern int smbmount_main(int argc, char ** argv);
#ifdef PP_FEAT_WLAN
extern int wpa_supplicant_main(int argc, char ** argv);
extern int wpa_cli_main(int argc, char ** argv);
#endif /* PP_FEAT_WLAN */
#ifdef PP_FEAT_BAYTECH_2_IPMI
extern int baytech2ipmi_main(int argc, char** argv);
#endif /* PP_FEAT_BAYTECH_2_IPMI */

#ifdef PP_FEAT_SYSOK_BLINKING
static void stop_sysok_blinking(void);
#endif

#if !defined(NDEBUG)
extern int __libc_fork(void);
#endif

#ifdef __cplusplus
}
#endif

#if !defined(NDEBUG)
/*
 * Segmentation fault signal handler
 *
 * We fork the faulting thread. The parent exits with exit status 1.
 * The child will just return and reexecute the faulty code. This is
 * required to get a valid core dump of the faulty thread.
 */
static void
sigsegv_handler(int signo)
{
    if (__libc_fork() > 0) {
	fprintf(stderr, "Segmentation fault (%d)\n", signo);
	exit(1);
    }
}

static sighandler_t
pp_signal(int signo, sighandler_t handler, int oneshot)
{
    struct sigaction sact, osact;
    sigemptyset(&sact.sa_mask);
    sact.sa_handler = handler;
    sact.sa_flags = oneshot ? SA_ONESHOT : 0;
    if (sigaction(signo, &sact, &osact) < 0) {
	return (SIG_ERR);
    } else {
	return osact.sa_handler;
    }
}
#endif /* !NDEBUG */

int
main(int argc, char ** argv)
{
    int ret = -1;
    char * argv0_copy = strdup(argv[0]);
    char * progname = basename(argv0_copy);
 
    /* login marks a login-shell by a preceeding '-'   *
     * we'll ignore it for selecting the right binary  */
    if (progname[0] == '-')
	progname = &progname[1];

    /* notify eric on 'external changes' */
    eric_config_ext_change_ntfy = 1;
    
#ifdef PP_FEAT_WLAN
    if (!strcmp(progname, "wpa_supplicant")) {
	return wpa_supplicant_main(argc, argv);
    } else if (!strcmp(progname, "wpa_cli")) {
	return wpa_cli_main(argc, argv);
    } else
#endif /* PP_FEAT_WLAN */
    if (!strcmp(progname, "eric_config")) {
	return eric_config_main(argc, argv);
    } else if (!strcmp(progname, "get_config")) {
	return get_config_main(argc, argv);
    } else if (!strcmp(progname, "config_rtceep")) {
	return config_rtceep_main(argc, argv);
#if defined(PP_FEAT_SNMP_TRAP) || defined(PP_FEAT_NETSNMP_TRAP)
    } else if (!strcmp(progname, "snmptrap")) {
	return snmptrap_main(argc, argv);
#endif /* PP_FEAT_SNMP_TRAP */
#if defined(PP_FEAT_SNMP_TRAPD) || defined(PP_FEAT_NETSNMP_TRAPD)
    } else if (!strcmp(progname, "snmptrapd")) {
	return snmptrapd_main(argc, argv);
#endif /* PP_FEAT_SNMP_TRAPD */
#if defined(PP_FEAT_SNMP_AGENT) || defined(PP_FEAT_NETSNMP_AGENT)
    } else if (!strcmp(progname, "snmpd")) {
	return snmpd_main(argc, argv);
#endif /* PP_FEAT_SNMP_AGENT */
#if defined(PP_FEAT_SSH)
    } else if (!strcmp(progname, "dropbearkey")) {
	return dropbearkey_main(argc, argv);
#endif /* PP_FEAT_SSH */
    } else if (!strcmp(progname, "dhcpcd")) {
	return dhcpcd_main(argc, argv);
    } else if (!strcmp(progname, "smbmnt")) {
	return smbmnt_main(argc, argv);
    } else if (!strcmp(progname, "smbmount")) {
	return smbmount_main(argc, argv);
#ifdef PP_FEAT_BAYTECH_2_IPMI
    } else if (!strcmp(progname, "baytech")) {
	return baytech2ipmi_main(argc, argv);
#endif /* PP_FEAT_BAYTECH_2_IPMI */
    }
    
    /* no need to notify eric - we are eric */
    eric_config_ext_change_ntfy = 0;
    
#if !defined(NDEBUG)
    /* add signal handler for segmentation fault */
    pp_signal(SIGSEGV, sigsegv_handler, 1);
#endif /* !NDEBUG */

    if (init() != 0) {
	/* not safe when not completely initialized */
	/* cleanup(); */
	goto bail;
    }
   
    if (nice(PP_GRAB_NICE) == -1) {
	/* just report - we do not exit since it's not so critical */
	pp_log_err("%s(): nice()", ___F);
    }

    pp_log("e-RIC server started.\n");
      
#ifdef PP_FEAT_SYSOK_BLINKING
    stop_sysok_blinking();
#endif
    
    postinit();

    while(1) pause();
    
    cleanup();

    pp_base_release_singleton(ERIC_PIDFILE);
    
    ret = 0;

 bail:
    return ret;
}

static int
init(void)
{
    if (pp_base_init("eric", LOG_NOT_SILENT) != 0) {
	pp_log("Initializing base-library failed.\n");
	return -1;
    }
    // don't use pp_log before libpp_base is initialized (name not set)
    DBG("initialized libpp_base\n");

    pp_i_am_eric = 1;
   
    switch (pp_base_enforce_singleton(ERIC_PIDFILE)) {
      case SINGLETON_ALREADY_RUNNING:
	pp_log("The program is already running.\n");
	return -1;
      case SINGLETON_UNCRITICAL_EXCEPTION:
      case SINGLETON_CRITICAL_EXCEPTION:
	  pp_log("An exception occured during singleton enforcement.\n");
	  return -1;
      default:
	  break;
    }

#if defined(PP_FEAT_RPCCFG)
    DBG("initializing rpc library .. \n");
    if (PP_FAILED(pp_rpc_init())) {
	DBG("Initializing rpc library failed .. \n");
	return -1;
    }
#endif /* PP_FEAT_RPCCFG */

    DBG("initializing liberic_config\n");
    if (eric_config_init(FLUSH_IN_BACKGROUND) != 0) {
	pp_log("Initializing config-library failed.\n");
	return -1;
    }

    DBG("initializing libpp_cfg\n");
    if (pp_cfg_init(PP_CD_FNAME_DEFAULT, 
                    PP_CD_OEM_SKEL_FNAME_DEFAULT) == PP_ERR) {
	pp_log("Initializing cfg-library failed.\n");
	return -1;
    }

    DBG("initializing libpp_hal\n");
    if (PP_FAILED(pp_hal_init())) {
	pp_log("Initializing hal-library failed.\n");
	return -1;
    }

    DBG("initializing libpp_ipc\n");
    if (PP_FAILED(pp_ipc_init())) {
	pp_log("Initializing ipc-library failed.\n");
	return -1;
    }

    DBG("initializing liberic_notify\n");
    if (eric_notify_init(NOTIFY_INIT_WITH_HOST_TRAPS) != 0) {
	pp_log("Initializing notify-library failed.\n");
	return -1;
    }

    DBG("initializing libpp_serial\n");
    if (PP_FAILED(pp_serial_init())
#if !defined(PP_BOARD_KXNG) // for now, we don't have any serial ports
	|| PP_FAILED(pp_serial_register_port("/dev/ttyS0",  1,  0))
	|| PP_FAILED(pp_serial_register_port("/dev/ttyS1",  0,  1))
#endif /* PP_BOARD_KXNG */
#ifdef PRODUCT_ICPMMD
	|| PP_FAILED(pp_serial_register_port("/dev/ttyS2",  0,  2))
	|| PP_FAILED(pp_serial_register_port("/dev/ttyS3",  0,  3))
	|| PP_FAILED(pp_serial_register_port("/dev/ttyS4",  0,  4))
	|| PP_FAILED(pp_serial_register_port("/dev/ttyS5",  0,  5))
	|| PP_FAILED(pp_serial_register_port("/dev/ttyS6",  0,  6))
	|| PP_FAILED(pp_serial_register_port("/dev/ttyS7",  0,  7))
	|| PP_FAILED(pp_serial_register_port("/dev/ttyS8",  0,  8))
	|| PP_FAILED(pp_serial_register_port("/dev/ttyS9",  0,  9))
	|| PP_FAILED(pp_serial_register_port("/dev/ttyS10", 0, 10))
	|| PP_FAILED(pp_serial_register_port("/dev/ttyS11", 0, 11))
	|| PP_FAILED(pp_serial_register_port("/dev/ttyS12", 0, 12))
	|| PP_FAILED(pp_serial_register_port("/dev/ttyS13", 0, 13))
	|| PP_FAILED(pp_serial_register_port("/dev/ttyS14", 0, 14))
	|| PP_FAILED(pp_serial_register_port("/dev/ttyS15", 0, 15))
	|| PP_FAILED(pp_serial_register_port("/dev/ttyS16", 0, 16))
	|| PP_FAILED(pp_serial_register_port("/dev/ttyS17", 0, 17))
#endif /* PRODUCT_ICPMMD */
	) {
	pp_log("Initializing serial-library failed.\n");
	return -1;
    }
   
    DBG("initializing libpp_bio\n");
    if (pp_bio_init() != 0) {
	pp_log("Initializing bio-library failed.\n");
	return -1;
    }

    DBG("initializing liberic_cron\n");
    if (eric_cron_init() != 0) {
	pp_log("Initializing cron-library failed.\n");
	return -1;
    }

#if defined(PP_FEAT_REMOTE_CONSOLE)
    DBG("initializing liberic_grab\n");
    if (pp_grab_init() != 0) {
	pp_log("Initializing grab-library failed.\n");
	return -1;
    }
#endif /* PP_FEAT_REMOTE_CONSOLE */

#if defined(PP_FEAT_REMOTE_CONSOLE) && !defined(PRODUCT_FLASHX4)
    /* kvm must be initialized before vsc, because vsc calls functions
     * of the kvm lib */
    DBG("initializing libpp_kvm\n");
    if (pp_kvm_init() != 0) {
	/* must be before pp_usb_init(), because of disabling
	   video throughput */
	pp_log("Initializing KVM-library failed.\n");
	return -1;
    }
    DBG("initializing libpp_vsc\n");
    if (pp_vsc_init() != 0) {
        pp_log("Initializing VSC-library failed.\n");
        return -1;
    }


#if defined(PP_FEAT_USB)
    DBG("initializing libpp_usb\n");
    if (pp_usb_init() != 0) {
	pp_log("Initializing of usb library failed.\n");
	return -1;
    }
#endif /* PP_FEAT_USB */

    DBG("initializing libpp_km\n");
    if (pp_km_init() != 0) {
	pp_log("Initializing KM-library failed.\n");
	return -1;
    }

    DBG("calling pp_km_reconfigure()\n");
    pp_km_reconfigure_all();

    DBG("initializing libpp_rfb\n");
    if (pp_rfb_init() != 0) {
	pp_log("Initializing RFB-library failed.\n");
	return -1;
    }
    
    pp_grab_start();

#endif /* PP_FEAT_REMOTE_CONSOLE && !PRODUCT_FLASHX4 */

    DBG("initializing liberic_misc\n");
    if (eric_misc_init() != 0) {
	pp_log("Initializing misc-library failed.\n");
	return -1;
    }

    DBG("initializing libpp_firmware\n");
    if (pp_firmware_init() != 0) {
	pp_log("Initializing firmware-library failed.\n");
	return -1;
    }

#if defined(PP_FEAT_POWERSWITCH)
    DBG("initializing libpp_power_switch\n");
    if (pp_power_switch_init() != 0) {
	pp_log("Initializing power switch-library failed.\n");
	return -1;
    }
#if (defined(PP_FEAT_PCI_ADC) && defined(PP_FEAT_PSU_ADAPT))
     pp_power_check_current_state();
#endif  
#endif /* PP_FEAT_POWERSWITCH */

    /* now read the user configs */
    DBG("initializing libpp_um\n");
    if (pp_um_init() == PP_ERR) {
	pp_log("Initializing um-library failed.\n");
	return -1;
    }

    DBG("initializing libpp_setup_proto\n");
    if (pp_setup_proto_init() != 0) {
	pp_log("Initializing setup-proto-library failed.\n");
	return -1;
    }
    
    DBG("initializing liberic_session\n");
    if (eric_session_init(MAX_SESSIONS, SESSION_TIMEOUT) != 0) {
	pp_log("Initializing session-library failed.\n");
	return -1;
    }

    DBG("initializing liberic_cert\n");
    if (eric_cert_init() != 0) {
	pp_log("Initializing cert-library failed.\n");
	return -1;
    }

    DBG("initializing IPMI client lib\n");
    if (pp_ipmi_init() != 0) {
        pp_log("Initializing IPMI client lib failed.\n");
    }

    DBG("initializing liberic_net\n");
    if (eric_net_init() != 0) {
	pp_log("Initializing net-library failed.\n");
	return -1;
    }

    DBG("initializing libpp_intl\n");
    if (pp_intl_init() != 0) {
	pp_log("Initializing intl-library failed.\n");
	return -1;
    }

    DBG("initializing liberic_webs\n");
    if (eric_webs_init() != 0) {
	pp_log("Initializing webs-library failed.\n");
	return -1;
    }

#ifdef PP_FEAT_SSH
    DBG("initializing libdropbear\n");
    if (PP_FAILED(pp_dropbear_init())) {
	pp_log("Initializing dropbear-library failed.\n");
	return -1;
    }
#endif /* PP_FEAT_SSH */

#if !defined(PRODUCT_FLASHX4)
#if defined(PP_FEAT_TERMINAL_CONSOLE)
    DBG("initializing liberic_term\n");
    if (eric_term_init() != 0) {
	pp_log("Initializing term-library failed.\n");
	return -1;
    }
#endif /* PP_FEAT_TERMINAL_CONSOLE */
  
#if defined (PP_FEAT_SIMPLERFB_SUPPORT)
    DBG("initializing libpp_simplerfb\n");
    if (pp_simplerfb_init() != 0) {
	pp_log("Initializing simplerfb-library failed.\n");
	return -1;
    }
#endif /* PP_FEAT_SIMPLERFB_SUPPORT */

#ifdef PP_FEAT_IPMI_SERVER
    DBG("initializing bmc\n");
    if (pp_bmc_init() != 0) {
    	pp_log("Initializing BMC failed.\n");
    	return -1;
    }
    DBG("starting bmc\n");
    if (pp_bmc_start() != 0) {
    	pp_log("Starting BMC failed.\n");
    	return -1;
    }
#endif /* PP_FEAT_IPMI_SERVER */

#ifdef PP_FEAT_CIM
    DBG("initializing libpp_cim\n");
    if (PP_FAILED(pp_cim_init())) {
	pp_log("Initializing CIM library failed.\n");
	return -1;
    }
#endif /* PP_FEAT_CIM */
    
#if defined(PP_FEAT_NETEVENT)
    DBG("initializing libpp_netevent\n");
    if (PP_FAILED(pp_netevent_init())) {
	pp_log("Initializing NetEvent library failed.\n");
	return -1;
    }
#endif /* PP_FEAT_NETEVENT */

#if defined(PP_FEAT_WS_MANAGEMENT)
    DBG("initializing libpp_wsman\n");
    if (pp_wsman_init() != 0) {
	pp_log("Initializing WS-Management-library failed.\n");
	return -1;
    }
#endif /* PP_FEAT_WS_MANAGEMENT */

    DBG("initializing libpp_ldap\n");
    if (pp_ldap_init() != 0) {
	pp_log("Initializing pp_ldap lib failed.\n");
	return -1;
    }

#if defined(PP_FEAT_AUTH_RADIUS)
    DBG("initializing radius\n");
    {
	char * auth_mode;
	pp_cfg_get(&auth_mode, "auth_mode");
	if (!strcmp(auth_mode, "radius")) {
	    pp_um_radius_init();
	    free(auth_mode);
	}
    }
#endif /* PP_FEAT_AUTH_RADIUS */

#ifdef PRODUCT_ERIC2
    DBG("initializing panel id\n");
    {
        int panel_id;
        pp_cfg_get_int(&panel_id,"video.panel_id");
        eric_misc_set_panel_id(panel_id);
    }
#endif /* PRODUCT_ERIC2 */

    /* configure serial interfaces */
    pp_serial_reconfigure(NULL);

#if defined(PP_FEAT_PEMX)
    DBG("starting disconf proto\n");
    if (pp_dc_server_init()!=0) {
	pp_log("Starting disconf failed.\n");
	return -1;
    }
#endif /* PP_FEAT_PEMX */

    DBG("starting network listener\n");
    if (PP_FAILED(eric_net_start_listener())) {
	pp_log("Starting network listener failed.\n");
	return -1;
    }

    eric_notify_post_event("Device successfully started.", "device", PP_NOTIFY_EVENT_GENERIC);

#if defined(PRODUCT_KX2) 
    log_event_t event; 
    
    event.eventcode = ERIC_EC_System_Startup;
    event.trapname = "rebootCompleted";
    event.objectname = "DKX";
    event.objectinstance = "DominionKX";
    event.trapoid = "rebootCompleted";
    event.eventdata.generictrapdata.trap_desc = "Device succesfully started";
    eric_notify_post_event((void*)&event, "device", PP_NOTIFY_EVENT_LEGACY);
#endif

#else /* PRODUCT_FLASHX4 */

    DBG("initializing libpp_flashprog\n");
    if (pp_flashprog_init() != 0) {
	pp_log("Initializing flashprog library failed.\n");
	return -1;
    }

#endif /* PRODUCT_FLASHX4 */

#ifdef PP_FEAT_RPCCFG
    DBG("starting the RPC server\n");
    if (PP_FAILED(pp_rpc_srv_start())) {
	pp_log("Starting the RPC server failed.\n");
	return -1;
    }
    pp_rpc_chkhost_cron();
#endif /* PP_FEAT_RPCCFG */

#if defined(PP_FEAT_MASS_STORAGE)
    DBG("starting USB MS BO thread\n");
    if (PP_FAILED(pp_usb_start_ms_bo_thread())) {
	pp_log("Starting the USB MS BO thread failed.\n");
	return -1;
}
#endif /* PP_FEAT_MASS_STORAGE */

#if defined(PP_FEAT_PROPCHANGE)
    /* The start of the propchange handler must be the last during initialization! */
    DBG("starting propchange handler\n");
    if (pp_propchange_start_main_handler() != 0) {
	pp_log("Starting the main propchange handler failed.\n");
	return -1;
    }
#endif /* PP_FEAT_PROPCHANGE */

#ifdef PP_FEAT_RDM_SUPPORT
    DBG("initializing RDM support\n");
    if (pp_rdm_initialize_database() != PP_SUC) {
        pp_log("Initializing RDM support failed.\n");
        return -1;
    }
#endif

#if defined(PRODUCT_KX2)
    int result = 0;

    DBG("initializing portmgr library .. \n");
    result = pp_portmgr_initialize();
    
    if ( result < 0 ) 
    {
         DBG("initializing portmgr library failed .. \n");
         return -1;
    }

    DBG("initializing cim protocol library .. \n");
    result = pp_init_cim_proto();

    if ( result != 0 )
    {
       DBG("Initializing cim protocol library failed .. \n");
       return -1;
    }

    pp_hal_power_supply_monitor_thread_start();  /* ! Auto detect power supply and notify */
    DBG("All set : Beep.. \n");	
    pp_hal_kx2_beep(1);
    
#endif

    return 0;
}

static void
cleanup(void)
{
#if defined(PP_FEAT_WS_MANAGEMENT)
    pp_wsman_cleanup();
#endif /* PP_FEAT_WS_MANAGEMENT */
#ifdef PP_FEAT_CIM
    pp_cim_cleanup();
#endif /* PP_FEAT_CIM */
#if defined(PP_FEAT_RDM_SUPPORT)
	pp_rdm_cleanup_database();
#endif
    pp_ipmi_cleanup();
#ifdef PP_FEAT_IPMI_SERVER
    pp_bmc_cleanup();
#endif /* PP_FEAT_IPMI_SERVER */
#if defined (PP_FEAT_SIMPLERFB_SUPPORT)
    pp_simplerfb_cleanup();
#endif /* PP_FEAT_SIMPLERFB_SUPPORT */
    eric_notify_cleanup();
#ifdef PP_FEAT_SSH
    pp_dropbear_cleanup();
#endif /* PP_FEAT_SSH */
    eric_cert_cleanup();
#if defined(PP_FEAT_TERMINAL_CONSOLE)
    eric_term_cleanup();
#endif /* PP_FEAT_TERMINAL_CONSOLE */
    eric_session_cleanup();
    pp_setup_proto_cleanup();
    eric_webs_cleanup();
    pp_intl_cleanup();
    eric_net_cleanup();
#if defined(PP_FEAT_REMOTE_CONSOLE)
    pp_vsc_cleanup();
    pp_rfb_cleanup();
    pp_km_cleanup();
    pp_grab_cleanup();
#endif /* PP_FEAT_REMOTE_CONSOLE */
    pp_firmware_cleanup();
    eric_misc_cleanup();
    pp_um_cleanup();
    pp_ipc_cleanup();
    pp_hal_cleanup();
    pp_cfg_cleanup();
    eric_cron_cleanup();
    pp_bio_cleanup();
    eric_config_cleanup();
    pp_base_cleanup();
    pp_dc_cleanup();
#if defined(PP_FEAT_NETEVENT)
    pp_netevent_cleanup();

#endif /* PP_FEAT_NETEVENT */

#if defined(PRODUCT_KX2)
    pp_cleanup_cim_proto();
    pp_portmgr_shutdown();

#endif /* PRODUCT_KX2 CIM */
}

#ifdef PP_FEAT_SYSOK_BLINKING
static void
stop_sysok_blinking(void)
{
    // startup successful, light up status led
    unsigned char state = 0;
    
    if (ioctl(eric_fd, PPIOCSTATUSLEDBLINKING, &state) == -1) {
	if (errno != EAGAIN) {
	    pp_log_err("%s(): ioctl(PPIOCSTATUSLEDBLINKING)", ___F);
	}
    }
}
#endif

static void
postinit(void)
{
    eric_webs_ipmi_sdr_list_start();
}

