package nn.pp.drvredir;

import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;

import nn.pp.rc.*;

class DriveSelectionDialog extends Dialog implements ActionListener {
    DriveAccess drvAccess;
    PrintStream logger;

    Choice drvChoice;
    Button refreshButton;
    Checkbox writeBox;
    
    Button okButton;
    Button cancelButton;
    
    boolean ok = false;
    boolean forceReadOnly;
    boolean writeSupport;
    String drive;
    
    Drive drives[];
    
    DriveSelectionDialog(Frame owner, DriveAccess drvAccess, PrintStream logger, boolean forceReadOnly) {
        super(owner, T._("Select a drive to redirect"), true);
        this.drvAccess = drvAccess;
        this.logger = logger;
        this.forceReadOnly = forceReadOnly;

    	addLayout();
    	addAvailableDrives();
    	pack();
    	
    	Rectangle ownerBounds;
    	if (owner != null) {
            ownerBounds = owner.getBounds();
    	} else {
    	    Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
    	    ownerBounds = new Rectangle(0, 0, sd.width, sd.height);
    	}
        Rectangle myBounds = getBounds();
        
        myBounds.x = Math.max(0, ownerBounds.x + ownerBounds.width / 2 - myBounds.width / 2);
        myBounds.y = Math.max(0, ownerBounds.y + ownerBounds.height / 2 - myBounds.height / 2);
        
        setBounds(myBounds);
    }

    private void addAvailableDrives() {
    	if (drvAccess == null) return;
    	
    	drives = drvAccess.getAvailableDrives();
        Arrays.sort(drives);
    	
    	drvChoice.removeAll();

    	if (drives != null) {
    	    for (int i = 0; i < drives.length; i++) {
    	    	drvChoice.add(drives[i].getNameAndDescription());
    	    }
    	    
    	    drvChoice.select(0);
    	} else {
    	    logger.println(T._("No drives to redirect found."));
    	}
    }
    
    private void addLayout() {
        setLayout(new BorderLayout());
        
        Panel top = new Panel(new FlowLayout(FlowLayout.CENTER));
        Panel top1 = new Panel(new GridLayout(2, 2, 5, 5));
    	top1.add(drvChoice = new Choice());
    	top1.add(refreshButton = new Button(T._("Refresh List")));
    	top1.add(writeBox = new Checkbox(T._("Enable Write support"), false));
    	top.add(top1);
    	add(top, BorderLayout.CENTER);
    	
    	Panel bottom = new Panel(new FlowLayout(FlowLayout.CENTER));
    	bottom.add(okButton = new Button(T._("OK")));
    	bottom.add(cancelButton = new Button(T._("Cancel")));
    	add(bottom, BorderLayout.SOUTH);

    	refreshButton.addActionListener(this);
    	okButton.addActionListener(this);
    	cancelButton.addActionListener(this);
    	
    	if (forceReadOnly) {
    	    writeBox.setEnabled(false);
    	}
    }

    public void actionPerformed(ActionEvent e) {
    	Object src = e.getSource();
    	
    	if (src == okButton) {
    	    int index = drvChoice.getSelectedIndex();
    	    if (index < 0) return;
    	    
    	    ok = true;
    	    drive = drives[index].getName();
    	    writeSupport = writeBox.getState();

    	    if(writeSupport) {
    	        ConfirmDialog dlg = new ConfirmDialog(
		    T._(
		    "Enabling Write Support is a very dangerous feature.\n" +
		    "The remote and the local operating system both will have\n" +
		    "write access to the media which could destroy all data on\n" +
		    "the drive. This should only be enabled with non-critical\n" +
		    "data. Are you sure that you want to enable Write Support?"
		    ),
		    T._("Warning"), ConfirmDialog.YES_NO, true);
	        dlg.show();
	        if (!dlg.yes) {
		    writeSupport = false;
	        }
	    }

    	    setVisible(false);
    	} else if (src == cancelButton) {
    	    ok = false;
    	    setVisible(false);
    	} else if (src == refreshButton) {
    	    addAvailableDrives();
    	}
    }
}
