package nn.pp.rc;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

public class ConfirmDialog extends Dialog implements ActionListener {
    final public static int OK = 0;
    final public static int OK_CANCEL = 1;
    final public static int YES_NO = 2;
    
    GridBagLayout gbLayout;
    GridBagConstraints gbc;
    Color frameColor = SystemColor.control;
    Color buttonColor = SystemColor.controlText;
    Font textFont = new Font("Helvetica", Font.BOLD, 12);
    Font buttonFont = new Font("Helvetica", Font.BOLD, 12);
    public boolean ok = false;
    public boolean cancel = false;
    public boolean yes = false;
    public boolean no = false;
    protected String[] lines;         // The lines of text to display
    protected int num_lines;          // The number of lines
    
    protected void createLines(String label) {
        StringTokenizer t = new StringTokenizer(label, "\n");
        num_lines = t.countTokens();
        lines = new String[num_lines];
        for(int i = 0; i < num_lines; i++) lines[i] = t.nextToken();
    }
    
    public ConfirmDialog(String text, String title, int type, boolean showModal) {
	super(new Frame(), title, showModal);
	enableEvents(WindowEvent.WINDOW_CLOSED);

	gbLayout = new GridBagLayout();
	gbc = new GridBagConstraints();
	setBackground(frameColor);
	setForeground(Color.black);
	setLayout(gbLayout);
	setFont(textFont);

	gbc.weightx = 1.0;
	gbc.weighty = 1.0;
	gbc.fill = GridBagConstraints.NONE;
	gbc.anchor = GridBagConstraints.WEST;
	gbc.insets = new Insets(0, 20, 0, 0);
	gbc.gridwidth = GridBagConstraints.REMAINDER; 
	
	createLines(text);
	for (int i = 0; i < num_lines; i++) {
	    Label l1 = new Label(lines[i]);
	    l1.setBackground(frameColor);
	    l1.setForeground(Color.black);
	    add(l1, gbc);
	}
	
	String t1, t2;
	int no;
	switch (type) {
	    case ConfirmDialog.OK_CANCEL:
	    	no = 2;
	    	t1 = T._("OK");
	    	t2 = T._("Cancel");
	    	break;
	    case ConfirmDialog.YES_NO:
	    	no = 2;
	    	t1 = T._("Yes");
	    	t2 = T._("No");
	    	break;
	    case ConfirmDialog.OK:
	    default:
	    	no = 1;
	    	t1 = T._("OK");
	    	t2 = "";
	    	break;
	}
	
	Button b1 = new Button(t1);
	b1.setBackground(buttonColor);
	b1.setForeground(frameColor);
	b1.setFont(buttonFont);
	b1.setActionCommand(t1);
	b1.addActionListener(this);
	b1.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
	gbc.insets = new Insets(10, 20, 20, 20);
	gbc.anchor = GridBagConstraints.EAST;
	gbc.gridwidth = 1; 
	add(b1, gbc);

	if (no == 2) {
	    Button b2 = new Button(t2);
	    b2.setBackground(buttonColor);
	    b2.setForeground(frameColor);
	    b2.setFont(buttonFont);
	    b2.setActionCommand(t2);
	    b2.addActionListener(this);
	    b2.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
	    gbc.anchor = GridBagConstraints.WEST;
	    gbc.gridwidth = GridBagConstraints.REMAINDER;
	    add(b2, gbc);
	}

	pack();
    }

    public void actionPerformed(ActionEvent event) {
	String command = event.getActionCommand();
	if (command.equals(T._("OK"))) {
	    ok = true;
	} else if (command.equals(T._("Cancel"))) {
	    cancel = true;
	} else if (command.equals(T._("Yes"))) {
	    yes = true;
	} else if (command.equals(T._("No"))) {
	    no = true;
	}
	setVisible(false);
    }

    public void processWindowEvent(WindowEvent event) {
	if (event.getID() == WindowEvent.WINDOW_CLOSING) {
	    setVisible(false);
	}
    }
}
