/**
 * CustomCursor (together with CursorType) is used for
 * changing the local applet cursor
 */

package nn.pp.rc;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.io.*;
import java.util.*;
import java.lang.reflect.*;

public class CustomCursor {
    private boolean	bSupportsCustom;
    private Dimension	cursorSize;
    private Integer	dMaxColors;
    private Hashtable   cursorHash;
    private int 	systemCursors;
    private Vector	cursors;
    private CursorType  currentCursor;    
    
    // this is a method to find the cursor names by xgettext
    String c1 = T.N_("Pixel");
    String c2 = T.N_("Transparent");
    String c3 = T.N_("Big");
    String c4 = T.N_("Default");
    String c5 = T.N_("Crosshair");

    public CustomCursor(String localcursor) {
	cursorHash = new Hashtable();
	dMaxColors = new Integer(0);
	fillSystemCursors();
	if (JVMVersionInfo.getJVMVersionInfo().isJava12()) {
	    fillCustomCursors();
	}
	currentCursor = getCursor(localcursor);
	if (currentCursor == null) {
	    currentCursor = getCursor("Default");
	}
    }

    public Object[] getCursors() {
	cursors = new Vector();

	for (Enumeration e = cursorHash.elements() ; e.hasMoreElements() ;) {
	    cursors.addElement(e.nextElement());    
	}
	return toArray(cursors);
    }

    public CursorType getCursor(String name) {
	if (name == null) return null;	
	return (CursorType) cursorHash.get(name);
    }

    public CursorType getCurrentCursor() {
	return currentCursor;
    }

    public void setCurrentCursor(CursorType cursor) {
	currentCursor = cursor;
    }

    private void fillSystemCursors() {
	Cursor     sysCursor;
	CursorType cursorType;

	sysCursor  = new Cursor(Cursor.DEFAULT_CURSOR);
	cursorType = new CursorType("Default", sysCursor);
	cursorType.cursor = sysCursor;
	cursorHash.put(T.N_("Default"), cursorType);

	sysCursor  = new Cursor(Cursor.CROSSHAIR_CURSOR);
	cursorType = new CursorType("Crosshair", sysCursor);
	cursorType.cursor = sysCursor;
	cursorHash.put(T.N_("Crosshair"), cursorType);
    }

    private void fillCustomCursors() {
	Cursor cursor;
	CursorType cursorType;
	InputStream istream;
	BufferedReader reader;
	StringTokenizer tokenizer;
	Image	cursorImage;
	String  cursorName;
	String  fileName;
	String  line=null;
	Integer hotX, hotY;
	Toolkit kit;
	Class	clToolkit;
	Method  me = null;

	kit = Toolkit.getDefaultToolkit();

	try {
	    clToolkit = Class.forName("java.awt.Toolkit");
	    me = clToolkit.getMethod("getMaximumCursorColors", null);
	} catch (Exception e) {
	    e.printStackTrace();
	}

	try {
	    dMaxColors = (Integer) me.invoke(kit, null);
	    if (dMaxColors == new Integer(0)) return;
	} catch (Exception e) {
	    e.printStackTrace();
	    return;
	}

	Class[]	 params  = new Class[3];
	Object[] arglist = new Object[3];
	params[0] = Image.class;
	params[1] = Point.class;
	params[2] = String.class;
	
	try {
	    clToolkit = Class.forName("java.awt.Toolkit");
	    me = clToolkit.getMethod("createCustomCursor", params);
	} catch (Exception e) {
	    e.printStackTrace();
	    return;
	}

	try {
	    istream = getClass().getClassLoader().getResourceAsStream("nn/pp/rc/cursors.txt");
	    reader = new BufferedReader(new InputStreamReader(istream));
	} catch (Exception e) {
	    e.printStackTrace();
	    return;
	}

	try {
	    while ((line = reader.readLine())!=null) {
		tokenizer = new StringTokenizer(line, " ");
		if (tokenizer.countTokens() != 4) continue;
		cursorName = tokenizer.nextToken();
		fileName   = tokenizer.nextToken();
		hotX = new Integer(tokenizer.nextToken());
		hotY = new Integer(tokenizer.nextToken());
		cursorImage = kit.getImage(getClass().getClassLoader().
					   getResource("nn/pp/rc/"+fileName));
		arglist[0] = cursorImage;
		arglist[1] = new Point(hotX.intValue(),hotY.intValue());
		arglist[2] = cursorName;
		cursor = (Cursor) me.invoke(kit, arglist);
		cursorType = new CursorType(cursorName, cursor);
		cursorType.cursor = cursor;
		cursorHash.put(cursorName, cursorType);
	    }
	} catch (Exception e) {
	    e.printStackTrace();
	}	
    }

    private Object[] toArray(Vector v) {
        Object[] os = new Object[v.size()];
        for(int i=0; i<v.size(); ++i) os[i] = v.elementAt(i);

        return os;
    }

    private static void swap (Vector aVector, int left, int right)
    {
	Object save = aVector.elementAt(left);
	aVector.setElementAt(aVector.elementAt(right), left);
	aVector.setElementAt(save, right);
    } 
}
