package nn.pp.rc;

import java.awt.*;

public class FixedLabel extends Label {
    private Dimension mydim = null;
    private String mystring;
    private boolean shrink;
    
    public FixedLabel(String fix, String s, boolean shrink) {
    	super(s);
    	mystring = fix;
    	this.shrink = shrink;
    }
    
    public FixedLabel(String fix, boolean shrink) {
    	this(fix, "", shrink);
    }
    
    public FixedLabel(String fix, String s) {
    	this(fix, s, false);
    }
    
    public FixedLabel(String fix) {
    	this(fix, "", false);
    }
    
    public Dimension getMinimumSize() {
	if (mydim == null) {
	    Font fontLabel = getFont();
	    FontMetrics fontMetrics = getFontMetrics(fontLabel);
	    mydim = new Dimension(fontMetrics.stringWidth(mystring),
				  super.getMinimumSize().height - (shrink ? 4 : 0));
	}
	return mydim;
    }
	
    /* java is strange: getMinimumSize should be the stronger constraint,
       but the layoutmanager takes at least the returned size, I have to
       return the appropriate getPreferredSize, too
    */
	
    public Dimension getPreferredSize() {
	return getMinimumSize();
    }
	
}

