package nn.pp.rc;

import java.awt.*;
import java.awt.event.*;
import java.io.*;

/**
 * Base for classes which do the actual mouse-move work
 *
 */

public abstract class MouseHandler implements ActionListener {
    protected Point oldPos = new Point(0,0);
    protected RCProto proto = null;
    protected Component comp;
    private J14WheelHandler whandler = null;
    private int pointerMask = 0;
    private J14MouseBtnMaskHandler j14_mbtn_handler = null;

    /*
     * abstract methods
     */
    public abstract boolean needMouseHandling();
    public abstract void handleMouseSyncKey();
    public abstract int  getPointerMask();
    protected abstract void processMouseEvent(MouseEvent me);

    public MouseHandler(Component comp) {
	//System.out.println("mouse handler: " + this.getClass().toString());
	this.comp = comp;
	if (JVMVersionInfo.getJVMVersionInfo().isJava14()) {
	    whandler = new J14WheelHandler();
	    j14_mbtn_handler = new J14MouseBtnMaskHandler();
	}
    }

    public void setRCProto(RCProto proto) {
	this.proto = proto;
	if (whandler != null) {
	    whandler.setRCProto(proto);
	}
    }

    public void clearPointerMask() {
	pointerMask = 0;
    }

    public int getPointerMask(AWTEvent e) {
	MouseEvent localme = (MouseEvent) e;
	
	if (j14_mbtn_handler != null) {
	    // Java 1.4
	    pointerMask = j14_mbtn_handler.processMouseBtnEvent(localme, pointerMask);
	} else {
	    // Java < 1.4 quirks: 
	    //     - mouse btn bits conflict with keyboard modifiers
	    //       (btn2/middle <-> Alt key, btn3/right <-> Meta key)
	    //     - heuristics for resolving conflicts:
	    //         - we assume that only one mouse button is really pressed
	    //         - mask: btn1 + btn2/btn3 -> real: probably btn1
	    //         - mask: btn2 + btn3 -> real: we assume Alt is down (more
	    //                                common than Meta) -> btn3
	    //     - MS Java VM 1.1:
	    //         - holding btns A and B and then releasing A yields same
	    //           bit mask as releasing B (both bits set) -> more than
	    //           one btn cannot be reliably supported
	    //
	    int mods = localme.getModifiers();
	    int mask = 0;

	    if ((mods & MouseEvent.BUTTON1_MASK) != 0) {
		mask = 1;
	    } else if ((mods & MouseEvent.BUTTON3_MASK) != 0) {
		mask = 4;
	    } else if ((mods & MouseEvent.BUTTON2_MASK) != 0) {
		mask = 2;
	    }

	    if (localme.getID() == MouseEvent.MOUSE_PRESSED) {
		pointerMask = mask;
	    } else if (localme.getID() == MouseEvent.MOUSE_RELEASED) {
		pointerMask = 0;
	    }
	}

	return pointerMask;
    }    

    public void handleMouseEvent(MouseEvent me) {
	if (whandler != null) {
	    if (whandler.processWheelEvent(me, getPointerMask()))
		return;
	}
	processMouseEvent(me);
    }
}
