package nn.pp.rc;

import java.awt.*;
import java.awt.image.*;
import java.io.*;

/*
 * interface for our RFB and RDP renderers
 *
 * implementing classes: RFBRenderer, RDPRenderer
 * 
 * @author Thomas Rendelmann, Peppercon AG
 */
public interface RCRenderer {

    public void setInterpol(boolean ip);
    
    public void setRenderSize(Dimension d);

    public void paint(Graphics g, boolean scale, Dimension scalesize);

    public void repaint();
    
    public void dispose();
    
    public void createScreenshot();
    
    public void setOSDColorAndPosition(Color bgColor, Color fgColor, int alpha, int position);
}
