package nn.pp.rc;

import java.awt.*;
import java.awt.event.*;
import java.lang.*;
import java.text.*;

public class RemoteConsoleApplication implements ParameterReader {
    /**************************************************************************
    * methods overridden from ParameterReader interface                       *
    **************************************************************************/

    public void parameterError(String s) throws Exception {
    	throw new Exception(s);
    }
    
    public String getRemoteHost() throws Exception {
    	return readParameter("HOST", true);
    }
    
    public String readParameter(String reqName, boolean required) throws Exception {
    	reqName = reqName.toUpperCase();
    	String ret = null;
    	
    	for (int i = 0; i < params.length; i++) {
    	    String name = params[i].toUpperCase();
    	    if (name.startsWith("/" + reqName) || name.startsWith("-" + reqName)) {
    	    	if ((i + 1) < params.length) {
    	    	    ret = params[i + 1];
    	    	}
    	    	break;
    	    }
    	}

	if (ret == null && required) {
	    parameterError(MessageFormat.format(T._("Required parameter \"{0}\" not found"),
	               new Object[] { reqName }));
	}
	
	return ret;
    }
    
    public String[] readArrayParameter(String basename) throws Exception {
	int index = 0;
	String s;

	while (null != (s = readParameter(basename + index, false))) ++index;
	String[] hotkeys = new String[index];
	for(int i = 0; i < index; ++i) {
	    s = readParameter(basename + i, false);
	    hotkeys[i] = s;
	}
	return hotkeys;
    }
    
    /**************************************************************************
    * local methods                                                           *
    **************************************************************************/

    private String params[];
    private RemoteConsoleLoader loader;
    
    public RemoteConsoleApplication(String params[]) {
    	this.params = params;
    }
    
    public Panel getRemoteConsole() {
    	loader = new RemoteConsoleLoader(this, null);
    	return loader;
    }
    
    public void runRemoteConsole(boolean inFrame) throws Exception {
    	loader.init(inFrame, null, null);
    }
    
    /**************************************************************************
    * static main method                                                      *
    **************************************************************************/

    public static void main(String params[]) {
    	RemoteConsoleApplication app = new RemoteConsoleApplication(params);
    	
    	try {
    	    Frame f = new MyFrame();
    	    Panel p = app.getRemoteConsole();
    	    f.add(p, BorderLayout.CENTER);
    	    app.runRemoteConsole(true);
    	} catch (Exception e) {
    	    e.printStackTrace();
    	}
    }
}


class MyFrame extends Frame {
    MyFrame() {
    	enableEvents(AWTEvent.MOUSE_EVENT_MASK);
    }
}
