/**
 * KbdFactory is responsible for dynamically caching
 * instantiating and loading kbd resources
 * it is implemented as a singleton for practical reason...
 * 31.10.2001 by Thomas Breitfeld, Peppercon AG
 */
package nn.pp.rckbd;

import java.util.*;
import java.net.URL;

public class KbdFactory{

    private static KbdFactory instance = null;
    private static final boolean debug = true;
    
    // prefixes for the class names to search for
    public static final String LAYOUT_CLASS
	= "nn.pp.rckbd.KbdLayout";
    public static final String TRANSLATOR_CLASS
	= "nn.pp.rckbd.KeyTranslator";
    public static final String MAPPING_CLASS
	= "nn.pp.rcsoftkbd.KbdMapping";

    // cache for already instantiated classes
    private Hashtable i_layouts;
    private Hashtable i_mappings;    
    private Hashtable i_trans;
    
    // lists of name that could potentially be tried to
    // be instantiated, success is rather douptful, mainly intended for GUI
    private Vector p_layouts;
    private Vector p_mappings;
    private Vector p_trans;
    public static URL applet_codebase;

    /**
     * we're a singleton
     */
    public static KbdFactory getInstance() {
	if(null == instance) instance = new KbdFactory();
	return instance;
    }
    
    /**
     * default constructor is adding the built-in
     * resources automatically to our vectors of potentially
     * loadable layout and mappings...
     */
    protected KbdFactory() {
	i_layouts   = new Hashtable();
	i_mappings  = new Hashtable();    
	i_trans     = new Hashtable();
	p_layouts   = new Vector();
	p_layouts.addElement("pc104");
	p_layouts.addElement("pc109");
	p_layouts.addElement("Mac");
	p_mappings  = new Vector();
	p_mappings.addElement(Locale.US);
	p_mappings.addElement(Locale.UK);
	p_mappings.addElement(Locale.GERMANY);
	p_mappings.addElement(new Locale("de", "CH"));
	p_mappings.addElement(Locale.FRANCE);
	p_mappings.addElement(Locale.ITALY);
	p_mappings.addElement(Locale.JAPAN);
	p_mappings.addElement(new Locale("es", "ES"));
	p_mappings.addElement(new Locale("pt", "PT"));
	p_mappings.addElement(new Locale("iw", "IL"));
	p_mappings.addElement(new Locale("ru", "RU"));
	p_mappings.addElement(new Locale("fi", "FI"));
	p_mappings.addElement(new Locale("sv", "SE"));
	p_mappings.addElement(new Locale("no", "NO"));
	p_mappings.addElement(new Locale("da", "DK"));
	p_mappings.addElement(new Locale("fr", "BE"));
	p_mappings.addElement(new Locale("nl", "BE"));
	p_trans = new Vector();
	p_trans.addElement(Locale.US);
	p_trans.addElement(Locale.GERMANY);
	p_trans.addElement(new Locale("de", "CH"));
	p_trans.addElement(Locale.FRANCE);
	p_trans.addElement(Locale.JAPAN);
	p_trans.addElement(new Locale("fr", "CH"));
	p_trans.addElement(Locale.UK);
	p_trans.addElement(new Locale("sv", "SE"));
	p_trans.addElement(new Locale("no", "NO"));
	p_trans.addElement(new Locale("fr", "BE"));
	p_trans.addElement(new Locale("nl", "BE"));
    } 
 
    /**
     * we need a constructor with params for additional
     * mappings in other jar files, this should get finally
     * configured by Applet parameters
     */
    protected KbdFactory(String[] whatever /* some parameters */) {
	this();
	// TODO: has to be written
    }

    /**
     * KbdLayout is the geographical definition of the kbd
     * and ist associated scancode dfinitions
     */
    public KbdLayout getKbdLayout (String layout) {
	return (KbdLayout)getResource(i_layouts, LAYOUT_CLASS, layout);
    }

    /**
     * returns all potentialle possible LayoutNames
     */
    public Object[] getKbdLayoutNames() {
	return toArray(p_layouts);
    }

    /**
     * Kbd Mappings are the labels on a particular KbdLayout
     */
    public Object getKbdMapping (String layout, Locale mapping) {
	return getLayoutResource(i_mappings, MAPPING_CLASS,
				 layout, mapping.toString());
    }

    public Object[] getKbdMappingNames() {
	return toArray(p_mappings);
    }
	
    public KeyTranslator getKeyTranslator (String layout, Locale trans) {
	return (KeyTranslator)getLayoutResource(i_trans, TRANSLATOR_CLASS,
						layout, trans.toString());
    }

    public Object[] getKbdTranslatorNames() {
	return toArray(p_trans);
    }
	
    public SoftKbd getSoftKbd(KeyEventHandler keh, Locale mapping,
			      String boardname, boolean interactive) {
	SoftKbd kbd = null;
	try {
	    kbd = (SoftKbd)Class.forName("nn.pp.rcsoftkbd.SoftKbdImpl").
		newInstance();
	    kbd.init(keh, mapping, boardname, interactive);
	} catch (Exception e) {
	    System.err.println(" KbdFactory: ERROR: getSoftKbd: " + e);
	    kbd = null; // explicit reset to null
	    e.printStackTrace();
	}
	return kbd;
    }

    /**
     * That is the dynamic load operations for layout dependent
     * resouces. If no layout specific resource can be found
     * the method tries to load a layout independent resource
     */
    private Object getLayoutResource(Hashtable h, String classbase,
				     String layout, String name) {
	String s = layout + "_" + name;
	Object r = h.get(s);
	if(null == r) {
	    if(null == (r = loadResource(classbase + s))) {    
		r = getResource(h, classbase, name);
            }
	    h.put(s, r);
	}
	return r;
    }
    
    /**
     * That ist the dynamic load operation,
     *
     * TODO: needs to be extended for dynamic jar file loading
     * and some configuration mechanism that maps requested
     * resource names to jar files
     */
    private Object getResource(Hashtable h, String classbase, String name) {
                
	Object r = h.get(name);
	if(null == r) { // try to find a matching class in current code base
	    r = loadResource(classbase + "_" + name);
	    // TODO: if still not found, load jar archive dynamically
	    h.put(name, r);
	}
	return r;
    }
    
    /**
     * this method assumes a naming scheme equivalent to the
     * java resource naming, i.e.:
     *    KbdTranslation_en_US
     * it starts with the full name and if loading fails it cuts
     * off the last underscore part and tries again, unless there
     * is no underscore left
     */
    private Object loadResource(String name) {
	Object o = null;
	try {
	    o = Class.forName(name).newInstance();
	    if(debug)
		System.err.println("KbdFactory: successfully loaded: " + name);
	} catch(Exception e) {
	    if(debug)
		System.err.println("KbdFactory: "+e);
	    int i = name.lastIndexOf('_');
	    if(i > 0) o = loadResource(name.substring(0, i));
	}
	return o;
    }

    private Object[] toArray(Vector v) {
	Object[] os = new Object[v.size()];
	for(int i=0; i<v.size(); ++i) os[i] = v.elementAt(i);
	return os;
    }
}	
