package nn.pp.rckbd;

import java.awt.*;
import java.util.*;
import java.awt.event.*;
import nn.pp.rc.*;

public class KeyEventHandler {
    
    private static final Object classLock = new Object();

    public KeyEventHandler(KbdLayout layout) {
   	lastmodifiers=new Hashtable(3);  
   	keydefs=new Hashtable();
	init(layout);
    }
  
    public void init(KbdLayout layout) {
	if(actuallayout != layout) {
	    actuallayout = layout;
	    KeyDef[] kbd_layout=layout.getKeyDefs();
	    keydefs.clear(); //Keydefs-HT resetten
	    for(int i=0; i<kbd_layout.length;i++)  //fill KeyDef-Hashtable 
		keydefs.put(new java.lang.Short(kbd_layout[i].keynr),
			    kbd_layout[i]);
	    resetAllModifiers();
	    if(softkbd != null) softkbd.setLayout(layout);
	    
	}
	
	timer = new GenericTimer(30, new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    synchronized (classLock) {
			if ( strgFlag ) {
			    strgFlag = false;
			    internalPressed(new Short((short)54), KEYBOARD);
			}
		    }
		}
	    });
	timer.setRepeats(false);	
	
    } 
  
    public void addSoftKbdSupport(SoftKbd kbd) {
 	this.softkbd=kbd;
    }      
  
    public void removeSoftKbdSupport() {
   	this.softkbd=null;
    } 
        
    public void pressed(java.lang.Short shortnr, java.lang.Boolean source) {
	
	synchronized (classLock) {
	    // AltGr Hack
	    if ( (shortnr.intValue() == 54) && (source.equals(KEYBOARD)) && !(timer.isRunning()) )   {
		timer.start();
		strgFlag = true;
		return;
	    }  	
	    /*
	     * We trigger on Alt or AltGr here in the 2nd stage of the AltGr hack, lets explain...
	     * - AltGr hack is used because Windows VM gives Ctrl followed by Alt on AltGr presses.
	     *   So if a Ctrl is followed by Alt in very short time, we only send AltGr,
	     *   if Alt does not follow we deliver the Ctrl
	     * - in KeyTranslatorBase::translateKeyEvent we introduced another hack, because
	     *   on newer Linux versions with newer X-servers AltGr is provided as Alt with keyLocation 
	     *   parameter set to KEY_LOCATION_RIGHT, we change that to AltGr manually
	     * ->to avoid sending Ctrl + AltGr in that case, we check for both Alt and AltGr here
	     */
	    if ( ((shortnr.intValue() == 55) || (shortnr.intValue() == 57)) &&
		 (source.equals(KEYBOARD)) ) {
		if ( strgFlag ) {
		    shortnr = new Short((short)57);
		    timer.stop();
		    strgFlag = false;
		    altgrFlag = true;
		} else if ( altgrFlag == true ) {
		    return;	
		}
	    }
	    internalPressed(shortnr, source);
	}
    }   
    
    public void internalPressed(java.lang.Short shortnr, java.lang.Boolean source) { 
	synchronized (classLock) {
 	    //aus der Keynr die Keydef laden
	    KeyDef actualkd=(KeyDef) keydefs.get(shortnr);
	    if(actualkd == null) return; //wenn keine KeyDef vorhanden - Abbruch
	    if(actualkd.isModifier()) {  //ist es ein Modifier?
	    	// Modifier von der Realtastatur, bereits in Table
	    	// von Softkeyboard initiated
	    	ModifierOptions modopt;
	    	if(null != (modopt=(ModifierOptions)lastmodifiers.get(shortnr))) {
		    if(source.equals(KEYBOARD)) {
		    	// in Sourcehashtable eintrage
		    	modopt.source = source;
		    	// ScanCodeEvent send/Softkeyboard benachrichtigen
		    	setClicked(shortnr, true);
		    	if(actualkd.isPermanentModifier())
			    lastmodifiers.remove(shortnr);
		    } else {
		    	if(actualkd.isPermanentModifier()) {
			    setClicked(shortnr,true);
		    	} else {
			    setClicked(shortnr,false);
		    	}
		    	lastmodifiers.remove(shortnr);
		    	if(softkbd!=null) setSoftKbdModifier();
		    }
		    return;
	    	}
	    	//brandneuer Modifier
	    	lastmodifiers.put(shortnr,
			          new ModifierOptions((KeyDef)keydefs.get(shortnr), source));
	    	if(softkbd!=null) setSoftKbdModifier();
	    }	
   	    setClicked(shortnr, true);    
   	}
    }
  
    public void released(java.lang.Short shortnr, java.lang.Boolean source)
    {
	synchronized (classLock) {
	    // AltGr Hack   
	    if ( (shortnr.intValue() == 54) && (altgrFlag) && 
		 (source.equals(KEYBOARD)) )		// Strg
		return;
		    	
	    if ( ((shortnr.intValue() == 55) || (shortnr.intValue() == 57)) && (altgrFlag) && 
		 (source.equals(KEYBOARD)) ) {	// Alt
		shortnr = new Short((short)57);
		altgrFlag = false;
	    }

	    KeyDef actualkd=(KeyDef) keydefs.get(shortnr);	
	    if(actualkd == null) return;			
	    if(actualkd.isModifier() && !actualkd.isPermanentModifier()) {
		if(source.equals(SOFTKEYBOARD))
		    return; // done with pressed
		else {// remove if HardKbd and normal modifier
		    lastmodifiers.remove(shortnr);
		}
	    }
	    setClicked(shortnr, false);				
	    ModifierOptions actualmod;
	    java.lang.Short modwithmapping=new Short((short)0);
	    int i=0;
	    // Modifiertable durchsuchen - Release der SoftKeyboardModifier
	    for (Enumeration e = lastmodifiers.keys() ; e.hasMoreElements() ;) {
		hilfshort = (java.lang.Short)e.nextElement();
		actualmod = (ModifierOptions)lastmodifiers.get(hilfshort);
		if(!actualmod.keydef.isPermanentModifier()
		   && actualmod.source.equals(SOFTKEYBOARD)) { 
		    setClicked(hilfshort,false);
		    lastmodifiers.remove(hilfshort);
		}  
	    }    
	    if(softkbd != null) setSoftKbdModifier();
	}
    }	

    /**
     * entry function for direct KeyEvents coming from the
     * hard keyboard
     * we try to fix some JRE bugs while putting every key
     * in a hash table and checking wether every 'pressed'
     * has a 'released'. If something strange is happening
     * we try to regenerate the other events, like
     * a type becomes a pressed and a single release becomes
     * a pressed and released
     */
    public void handleHardKbdEvent(Short keynr, int id) {
        
	switch(id) {
	  case KeyEvent.KEY_PRESSED:
	      if(!hardkbd.contains(keynr)) {
		  /* first press -> press always */
		  hardkbd.addElement(keynr);
		  pressed(keynr, KEYBOARD);
	      } else {
		  /* press only again if its no modifier */
		  KeyDef actualkd=(KeyDef) keydefs.get(keynr);
		  if (actualkd != null &&
		      !(actualkd.isModifier() || actualkd.isPermanentModifier()))
		      pressed(keynr, KEYBOARD);
	      }	      
	      break;
	  case KeyEvent.KEY_TYPED:    
	      if(!hardkbd.contains(keynr)) {
		  /* If we did not get a pressed event for this key before,
		     we assume only TYPED is valid, so we press/release
		     at once. Workaround for Sun Win32 JVM problem
		     with AltGr+\ on german keyboards.
		     Replaces the workaround which just assumed "pressed"
		     in this case, for situations where only TYPED and
		     RELEASED were sent. */
		  pressed(keynr, KEYBOARD); 
		  released(keynr, KEYBOARD);
	      }
	      break;
	  case KeyEvent.KEY_RELEASED:
	      int i;
	      if((i = hardkbd.indexOf(keynr)) >= 0) {
		  hardkbd.removeElementAt(i);
	      } else { 	 
		  pressed(keynr, KEYBOARD); 	 
	      }
	      released(keynr, KEYBOARD);
	}
    }

    /**
     * This method releases all keys either pressed on hard or
     * softkbd. This includes modfies etc. The kbd should
     * be in a clean state afterwards
     */
    public void releaseAllKeys() {
	Short key;
	for(int i = 0; i < hardkbd.size(); ++i) 
	    released((Short)hardkbd.elementAt(i), KEYBOARD);
	hardkbd.removeAllElements();
	resetModifiers(KeyDef.NORMALMOD);
    }
    
    private byte getKeyCode (java.lang.Short shortnr, boolean clicked) {
        KeyDef kd=(KeyDef)keydefs.get(shortnr);
   	return kd.getKeyCode(lastmodifiers, clicked, ctrl_counter);
    	
    }

    private void setClicked(java.lang.Short shortnr, boolean clicked) {
  	byte keycode=getKeyCode(shortnr, clicked);
  	
  	if ((keycode & (byte)~0x80) == 0x36 || (keycode & (byte)~0x80) == 0x3A) {
  	    if (clicked) {
  	    	ctrl_counter++;
  	    } else {
  	    	ctrl_counter--;
  	    }
  	}
  	
   	KeyboardEvent keyevt = new KeyboardEvent(keycode);
   	
   	fireKeyboardEvent(keyevt);
	
   	if(softkbd!=null) softkbd.setClicked(shortnr, clicked);  
    }	      

    private void fireKeyboardEvent(KeyboardEvent keyevt) {
 	KeyboardListener listener;
 	 	
   	for(int i=0; i<keyboardlisteners.size(); i++)
	    {
	  	listener=(KeyboardListener) keyboardlisteners.elementAt(i); 
	    	listener.fired(keyevt);
	    }
    }  
  
    public KbdLayout getActualLayout() {
   	return actuallayout;
    }
  
    public void resetAllModifiers() { 
	resetModifiers(KeyDef.NORMALMOD);
	resetModifiers(KeyDef.PERMANENTMOD);
    }   	   

    private void resetModifiers(byte ModType) {
   	java.lang.Short actualmod;
	
   	for (Enumeration e = lastmodifiers.keys(); e.hasMoreElements();) {
	    actualmod=(java.lang.Short)e.nextElement();
	    KeyDef actualkd=(KeyDef) keydefs.get(actualmod);
	    if(actualkd.isPermanentModifier()) {
		// if it is a permanent modifier and we should reset them,
		// do it so
		if (ModType == KeyDef.PERMANENTMOD) {
		    setClicked(actualmod,true);
		    setClicked(actualmod,false);
		    lastmodifiers.remove(actualmod);
		}
	    } else {
		// if it is not a permanent modifier and we should reset NORMAL
		// modifiers, do it so
		if (ModType == KeyDef.NORMALMOD) {
		    setClicked(actualmod,false);
		    lastmodifiers.remove(actualmod);
		}
	    }
	}
	if(softkbd != null) setSoftKbdModifier();
    }
    
    private void setSoftKbdModifier(){
 	int i=0;
	softkbd.changeModifier(KeyDef.SHORTNOP);
 	if(!lastmodifiers.isEmpty()) {
	    //Wenn Table nicht leer, Modifier mit Mappings suchen
	    for (Enumeration e = lastmodifiers.keys(); e.hasMoreElements();) {
		hilfshort=(java.lang.Short)e.nextElement();      
		if(softkbd.hasMapping(hilfshort)) {
		    softkbd.changeModifier(hilfshort);
		}
	    }
	} 
    }   
    
    public String getKeyString(Short key) {
    	if (softkbd == null) return null;
    	
    	String ret = null;
    	String _ret;
    	
    	_ret = softkbd.getKeyString(key, KeyDef.SHORTNOP);
    	if (_ret != null) {
    	    ret = _ret;
    	}
    	
 	if(!lastmodifiers.isEmpty()) {
	    //Wenn Table nicht leer, Modifier mit Mappings suchen
	    for (Enumeration e = lastmodifiers.keys(); e.hasMoreElements();) {
		hilfshort=(java.lang.Short)e.nextElement();
		if(softkbd.hasMapping(hilfshort)) {
		    _ret = softkbd.getKeyString(key, hilfshort);
		    if (_ret != null) {
		    	ret = _ret;
		    }
		}
	    }
	}
	
	return ret;
    }
  
    //--------------------------------------------------------------------
	
    //SCANCODE
	
    public synchronized void addKeyboardListener(KeyboardListener l) {
	keyboardlisteners.addElement(l);
    }

    public synchronized void removeKeyboardListener(KeyboardListener l) {
	keyboardlisteners.removeElement(l);
    } 
        
    private SoftKbd softkbd = null;
    private Vector  hardkbd = new Vector();
    private Hashtable lastmodifiers;
    private Hashtable keydefs;
    private KbdLayout actuallayout = null;
    private int ctrl_counter = 0;
    private java.lang.Short hilfshort=new java.lang.Short((short)0);
    private Vector keyboardlisteners=new Vector();
    private GenericTimer timer;
    public boolean strgFlag, altgrFlag = false;
    public static final java.lang.Boolean KEYBOARD
	= new java.lang.Boolean(false);
    public static final java.lang.Boolean SOFTKEYBOARD
	= new java.lang.Boolean(true);
}

class ModifierOptions {
    public KeyDef keydef;
    public Boolean source;
    
    ModifierOptions(KeyDef kd, Boolean source) {
	this.keydef=kd;
	this.source=source;
    }  	
} 		

