package nn.pp.rcrdp;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import nn.pp.rc.*;

/**
 * Standard mouse movements for RDP protocol
 *
 */

public class MouseHandlerRDP extends MouseHandler {
    int pointerMask = 0;
    RDPProto rdp;
    
    public MouseHandlerRDP(Component comp) {
	super(comp);
    }
    
    public int getPointerMask(AWTEvent e) {
	MouseEvent localme = (MouseEvent) e;
	pointerMask = 0;
	
	int id = localme.getID();
	int button = localme.getButton();
	
	if(id != MouseEvent.MOUSE_PRESSED && id != MouseEvent.MOUSE_RELEASED) {
	    pointerMask |= RDPConstants.mouseFlagMove;
	    return pointerMask;
	}
	
	if(button == MouseEvent.BUTTON1)
	    pointerMask = RDPConstants.mouseFlagButton1;
	else if(button == MouseEvent.BUTTON2)
	    pointerMask = RDPConstants.mouseFlagButton3;	// Java Button 2 is
	else if(button == MouseEvent.BUTTON3)			//    RDP button 3 and
	    pointerMask = RDPConstants.mouseFlagButton2;	//    reverse
	
	if (id == MouseEvent.MOUSE_PRESSED) {
	    pointerMask |= RDPConstants.mouseFlagDown;
	}
	
	return pointerMask;
    }

    public int  getPointerMask() {
	return pointerMask;
    }
    
    private void sendPointerEvent(int x, int y, int pointerMask) {
	if(proto != null) {
	    //System.out.println("PointerMask: " + Integer.toHexString(pointerMask));
	    try {
	    	proto.writePointerEvent(false, x, y, 0, pointerMask);
	    }
	    catch (IOException e) {
	    	System.out.println("Could not write MouseEvent: "+e.getMessage());
            }
        }
	else {
	    System.out.println("MouseHandlerRDP: proto not ready");
	}
    }
    
    private boolean processWheelEvent(MouseEvent me) {
	// check for wheel turning if Java >= 1.4
	if(JVMVersionInfo.getJVMVersionInfo().isJava14()) {
	    if(me instanceof MouseWheelEvent) {
	    	MouseWheelEvent we = (MouseWheelEvent) me;
	    	int rot = we.getWheelRotation();
	    	if(rot < 0) {
	    	    pointerMask = RDPConstants.mouseFlagButton4;
	    	}
	    	else if(rot > 0) {
	    	    pointerMask = RDPConstants.mouseFlagButton5;
	    	}
	    	else {
	    	    return false;    // can this happen?
	    	}
	    	sendPointerEvent(me.getX(), me.getY(), pointerMask);
	    	return true;
	    }
	}
	return false;
    }

    public void processMouseEvent(MouseEvent me) {
	int pointerMask = 0;
	
	int eID = me.getID();

	switch (eID) {
	  case MouseEvent.MOUSE_PRESSED:
	      comp.requestFocus();
	  case MouseEvent.MOUSE_RELEASED:
	  case MouseEvent.MOUSE_MOVED:
	  case MouseEvent.MOUSE_DRAGGED:
	      pointerMask = getPointerMask(me);
	      sendPointerEvent(me.getX(), me.getY(), pointerMask);
	      break;
	}

	oldPos.x = me.getX();
	oldPos.y = me.getY();
    }

    // we have to override this here because we use wheel functionality
    // in a different manner here
    public void handleMouseEvent(MouseEvent me) {
	if(processWheelEvent(me)) {
	    return;
	}
	processMouseEvent(me);
    }

    public void actionPerformed(ActionEvent e) {
    }

    public boolean needMouseHandling() {
	return true;
    }

    public void handleMouseSyncKey() {
	// do nothing here
    }
}
