package nn.pp.rcrdp;

/**
 * class RDPConstants
 * 
 * this class was designed to make all the constants of the RDP
 * protocol available (comparable to a C header file)
 */
 
public class RDPConstants  {
    // ISO PDU types
    public final static int isoPDUCR               = 0xE0;	/* Connection Request */
    public final static int isoPDUCC               = 0xD0;	/* Connection Confirm */
    public final static int isoPDUDR               = 0x80;	/* Disconnect Request */
    public final static int isoPDUDT               = 0xF0;	/* Data */              
    public final static int isoPDUER               = 0x70;	/* Error */             
    
    // MCS PDU types
    public final static int mcsEDRQ                = 1;		/* Erect Domain Request */         
    public final static int mcsDPUM                = 8;		/* Disconnect Provider Ultimatum */
    public final static int mcsAURQ                = 10;	/* Attach User Request */          
    public final static int mcsAUCF                = 11;	/* Attach User Confirm */          
    public final static int mcsCJRQ                = 14;	/* Channel Join Request */         
    public final static int mcsCJCF                = 15;	/* Channel Join Confirm */         
    public final static int mcsSDRQ                = 25;	/* Send Data Request */            
    public final static int mcsSDIN                = 26;	/* Send Data Indication */    
    
    // MCS constants
    public final static int mcsConnectInitial      = 0x7f65;
    public final static int mcsConnectResponse     = 0x7f66;
    public final static int mcsTagDomainParams     = 0x30;
    public final static int mcsGlobalChannel       = 1003;
    public final static int berTagBoolean          = 1;
    public final static int berTagInteger          = 2;    
    public final static int berTagOctetString      = 4;
    public final static int berTagResult           = 10;

    // Secure constants
    public final static int secRandomSize          = 32;
    public final static int secModulusSize         = 64;
    public final static int secPaddingSize         = 8;
    public final static int secExponentSize        = 4;

    public final static int secClientRandom        = 0x0001;
    public final static int secEncrypt             = 0x0008;
    public final static int secLogonInfo           = 0x0040;
    public final static int secLicenceNeg          = 0x0080;

    public final static int secTagSrvInfo          = 0x0c01;
    public final static int secTagSrvCrypt         = 0x0c02;
    public final static int secTagSrv3             = 0x0c03;

    public final static int secTagCliInfo          = 0xc001;
    public final static int secTagCliCrypt         = 0xc002;
    public final static int secTagCli4             = 0xc004;
    public final static int secTagCliChannels      = 0xc003;

    public final static int secTagPubkey           = 0x0006;
    public final static int secTagKeysig           = 0x0008;

    public final static int secRsaMagic            = 0x31415352;	/* RSA1 */

    // RDP licensing constants
    public final static int licenceTokenSize       = 10;    
    public final static int licenceHwidSize        = 20;    
    public final static int licenceSignatureSize   = 16;    
                                  
    public final static int licenceTagDemand       = 0x01;  
    public final static int licenceTagAuthreq      = 0x02;  
    public final static int licenceTagIssue        = 0x03;  
    public final static int licenceTagReissue      = 0x04;  
    public final static int licenceTagPresent      = 0x12;  
    public final static int licenceTagRequest      = 0x13;  
    public final static int licenceTagAuthresp     = 0x15;  
    public final static int licenceTagResult       = 0xff;  
                                  
    public final static int licenceTagUser         = 0x000f;
    public final static int licenceTagHost         = 0x0010;
    
    // RDP constants
    public final static int rdpPDUDemandActive     = 1;
    public final static int rdpPDUConfirmActive    = 3;
    public final static int rdpPDUDeactivate       = 6;
    public final static int rdpPDUData             = 7;

    public final static int rdpDataPDUUpdate       = 2;
    public final static int rdpDataPDUControl      = 20;
    public final static int rdpDataPDUPointer      = 27;
    public final static int rdpDataPDUInput        = 28;
    public final static int rdpDataPDUSynchronise  = 31;
    public final static int rdpDataPDUBell         = 34;
    public final static int rdpDataPDULogon        = 38;
    public final static int rdpDataPDUFont2        = 39;

    public final static int rdpCtlRequestControl   = 1;
    public final static int rdpCtlGrantControl     = 2;
    public final static int rdpCtlDetach           = 3;
    public final static int rdpCtlCooperate        = 4;

    public final static int rdpUpdateOrders        = 0;
    public final static int rdpUpdateBitmap        = 1;
    public final static int rdpUpdatePalette       = 2;
    public final static int rdpUpdateSynchronize   = 3;

    public final static int rdpPointerClear        = 1;
    public final static int rdpPointerMove         = 3;
    public final static int rdpPointerColor        = 6;
    public final static int rdpPointerCached       = 7;

    public final static int rdpInputSynchronize    = 0;
    public final static int rdpInputCodepoint      = 1;
    public final static int rdpInputVirtKey        = 2;
    public final static int rdpInputScancode       = 4;
    public final static int rdpInputMouse          = 0x8001;
    
    public final static String rdpSource           = "MSTSC";
    
    // RDP capabilities
    public final static int rdpCapsetGeneral       = 1;
    public final static int rdpCaplenGeneral       = 0x18;
    public final static int osMajorTypeUnix        = 4;
    public final static int osMinorTypeXserver     = 7;        

    public final static int rdpCapsetBitmap        = 2;
    public final static int rdpCaplenBitmap        = 0x1C;

    public final static int rdpCapsetOrder         = 3;
    public final static int rdpCaplenOrder         = 0x58;
    public final static int orderCapNegotiate      = 2;        
    public final static int orderCapNosupport      = 4;

    public final static int rdpCapsetBmpCache      = 4;
    public final static int rdpCaplenBmpCache      = 0x28;

    public final static int rdpCapsetControl       = 5;
    public final static int rdpCaplenControl       = 0x0C;

    public final static int rdpCapsetActivate      = 7;
    public final static int rdpCaplenActivate      = 0x0C;

    public final static int rdpCapsetPointer       = 8;
    public final static int rdpCaplenPointer       = 0x08;

    public final static int rdpCapsetShare         = 9;
    public final static int rdpCaplenShare         = 0x08;

    public final static int rdpCapsetColCache      = 10;
    public final static int rdpCaplenColCache      = 0x08;

    public final static int rdpCapsetUnknown       = 13;
    public final static int rdpCaplenUnknown       = 0x9C;
    
    // logon flags
    public final static int rdpLogonNormal         = 0x33;
    public final static int rdpLogonAuto           = 0x8;
    public final static int rdpLogonblob           = 0x100;
    
    // rdp Order constants
    //     order flags
    public final static int rdpOrderStandard       = 0x01;
    public final static int rdpOrderSecondary      = 0x02;
    public final static int rdpOrderBounds         = 0x04;
    public final static int rdpOrderChange         = 0x08;
    public final static int rdpOrderDelta          = 0x10;
    public final static int rdpOrderLastBounds     = 0x20;
    public final static int rdpOrderSmall          = 0x40;
    public final static int rdpOrderTiny           = 0x80;
    
    //     order types
    public final static int rdpOrderDestBlt        = 0;  
    public final static int rdpOrderPatBlt         = 1;   
    public final static int rdpOrderScreenBlt      = 2;
    public final static int rdpOrderLine           = 9;     
    public final static int rdpOrderRect           = 10;    
    public final static int rdpOrderDeskSave       = 11;
    public final static int rdpOrderMemBlt         = 13;  
    public final static int rdpOrderTriBlt         = 14;  
    public final static int rdpOrderPolyLine       = 22;
    public final static int rdpOrderText2          = 27;
    
    //     secondary order types    
    public final static int rdpOrderRawBmpCache    = 0;
    public final static int rdpOrderColCache       = 1;    
    public final static int rdpOrderBmpCache       = 2;    
    public final static int rdpOrderFontCache      = 3;   
    
    // keyboard/mouse flags
    public final static int mouseFlagMove          = 0x0800;
    public final static int mouseFlagButton1       = 0x1000;	// left
    public final static int mouseFlagButton2       = 0x2000;	// right
    public final static int mouseFlagButton3       = 0x4000;	// middle
    public final static int mouseFlagButton4       = 0x0280;	// wheel up
    public final static int mouseFlagButton5       = 0x0380;	// wheel down
    public final static int mouseFlagDown          = 0x8000;
    
    public final static int keyFlagRight           = 0x0001;
    public final static int keyFlagExt             = 0x0100;
    public final static int keyFlagDown            = 0x4000;
    public final static int keyFlagUp              = 0x8000;
    public final static int rdpKeyPressed          = 0x0000;
    public final static int rdpKeyReleased         = keyFlagDown | keyFlagUp;
    
    // other flags
    public final static int mixTransparent         = 0;
    public final static int mixOpaque              = 1;
    
    // text flags
    public final static int text2Vertical          = 0x04;
    public final static int text2ImplicitX         = 0x20;
    
    // blitting opcodes
    public final static int rdpBlitClear           = 0;
    public final static int rdpBlitNor             = 1;  
    public final static int rdpBlitAndInverted     = 2;  
    public final static int rdpBlitCopyInverted    = 3;  
    public final static int rdpBlitAndReverse      = 4;  
    public final static int rdpBlitInvert          = 5;  
    public final static int rdpBlitXor             = 6;  
    public final static int rdpBlitNand            = 7;  
    public final static int rdpBlitAnd             = 8;  
    public final static int rdpBlitEquiv           = 9;  
    public final static int rdpBlitNoop            = 10; 
    public final static int rdpBlitOrInverted      = 11; 
    public final static int rdpBlitCopy            = 12; 
    public final static int rdpBlitOrReverse       = 13; 
    public final static int rdpBlitOr              = 14; 
    public final static int rdpBlitSet             = 15; 
    public final static int rdpBlitTransparent     = 16; 
    
    // brush styles
    public final static int brushStyleSolid        = 0;
    public final static int brushStyleHatch        = 2;
    public final static int brushStylePattern      = 3;
    
    // keyboard layouts
    public final static int kbdLayoutAr            = 0x401;
    public final static int kbdLayoutDa            = 0x406;
    public final static int kbdLayoutDe            = 0x407;
    public final static int kbdLayoutEnUS          = 0x409;
    public final static int kbdLayoutEs            = 0x40a;
    public final static int kbdLayoutFi            = 0x40b;
    public final static int kbdLayoutFr            = 0x40c;
    public final static int kbdLayoutHu            = 0x40e;
    public final static int kbdLayoutIt            = 0x410;
    public final static int kbdLayoutJa            = 0x411;
    public final static int kbdLayoutNo            = 0x414;
    public final static int kbdLayoutPl            = 0x415;
    public final static int kbdLayoutRu            = 0x419;
    public final static int kbdLayoutHr            = 0x41a;
    public final static int kbdLayoutSv            = 0x41d;
    public final static int kbdLayoutTh            = 0x41e;
    public final static int kbdLayoutTr            = 0x41f;
    public final static int kbdLayoutSl            = 0x424;
    public final static int kbdLayoutLv            = 0x426;
    public final static int kbdLayoutLt            = 0x427;
    public final static int kbdLayoutMk            = 0x42f;
    public final static int kbdLayoutFo            = 0x438;
    public final static int kbdLayoutEnUK          = 0x809;
    public final static int kbdLayoutPt            = 0x816;
}	                                             
