package nn.pp.rcrdp;

import java.awt.*;
import java.awt.image.*;
import java.io.*;

public class RDPRendererJ11 extends RDPRenderer {
    
    private boolean repaint_done;
    
    public RDPRendererJ11(Component comp) {
    	super(comp);
    	debug("RDP new RDPRendererJ11");
    }
    
    public void setInterpol(boolean ip) {
    	// ignore
    }
    
    public void setRenderSize(Dimension d) {
    	super.setRenderSize(d);
    	debug("RDP RDPRendererJ11 setRenderSize");
    	if(vimg != null) vimg.flush();
	if(gvimg != null) gvimg.dispose();
	vimg = comp.createImage(d.width, d.height);
	gvimg = vimg.getGraphics();
    }

    public void paint(Graphics g, boolean scale, Dimension scalesize) {
/*
	if(vimg != null) {
	    if(scale) {
	        g.drawImage(vimg, 0, 0, scalesize.width, scalesize.height,null);
	    } else {
	        g.drawImage(vimg, 0, 0, null);
	    }
	}
*/
    	if(vimg == null) {
    	    return;
    	}
    	
	if(scale) {
    	    // we have to set different clippings here
    	    // because of the scaling
	    setClippingForScaling(g, scalesize);
	    g.drawImage(vimg, 0, 0, scalesize.width, scalesize.height, null);
	}
	else {
	    g.drawImage(vimg, 0, 0, null);
	}
	synchronized(this) {
	    repaint_done = true;
	    notifyAll();
	}
    }

    public void repaint() {
	synchronized(this) {
	    comp.repaint();
	    repaint_done = false;
	    while(!repaint_done) {
		try { wait(); } catch(InterruptedException ignore) {}
	    }
	}
    }
    
    public void repaint(int x, int y, int w, int h) {
	synchronized(this) {
	    comp.repaint(x, y, w, h);
	    repaint_done = false;
	    while(!repaint_done) {
		try { wait(); } catch(InterruptedException ignore) {}
	    }
	}
    }
    
}
