package nn.pp.sara;

import java.awt.*;
import java.awt.event.*;
import nn.pp.rc.*;

class MousePanel extends InfoPanelPart implements ActionListener {
    Label sourceLabel;
    boolean hasSource;
    MouseVisual visual;
    Label pos, buttons, wheel, sync;
    GenericTimer wheelTimer, syncTimer;
    
    private int buttonMask;
    
    MousePanel(InfoPanel info) {
    	super(info, true, true);
    	
    	buttonMask = 0;
    	
    	visual = new MouseVisual(this);
    	wheelTimer = new GenericTimer(1000, this);
    	syncTimer = new GenericTimer(2000, this);
    }
    
    private String getPos(int x, int y, boolean relative) {
    	String s = "";
    	if (relative) s += "R ";
    	s += "(" + x + ", " + y + ")";
    	return s;
    }
    
    private String getButtons(int mask) {
    	String s = "";
    	if ((mask & (1 << 0)) != 0) {
    	    s += "L ";
    	}
    	if ((mask & (1 << 1)) != 0) {
    	    s += "M ";
    	}
    	if ((mask & (1 << 2)) != 0) {
    	    s += "R ";
    	}
    	
    	return s;
    }
    
    private String getButtonChange(int oldMask, int newMask) {
    	String buttons[] = { "Left", "Middle", "Right" };
    	String ret = "";
    	for (int i = 0; i < buttons.length; i++) {
    	    if ( ((newMask & (1 << i)) != 0) && ((oldMask & (1 << i)) == 0) ) {
    	    	ret += buttons[i] + " button down ";
    	    } else if ( ((newMask & (1 << i)) == 0) && ((oldMask & (1 << i)) != 0) ) {
    	    	ret += buttons[i] + " button up ";
    	    }
    	}
    	return ret;
    }
    
    private String getWheel(int z) {
    	String s = "";
    	if (z < 0) {
    	    s = "Up";
    	} else if (z > 0) {
    	    s = "Down";
    	}
    	
    	return s;
    }
    
    private void processPos(int x, int y, boolean relative) {
    	pos.setText(getPos(x, y, relative));
    }
    
    private int oldButtonMask = -1;
    
    private boolean processButtons(int mask) {
    	boolean notify = false;

    	if (buttonMask != mask) {
    	    visual.processButtons(mask);
    	    buttons.setText(getButtons(mask));
    	    notify = true;
    	}

    	buttonMask = mask;
    	return notify;
    }

    private synchronized boolean processWheel(int z) {
    	boolean notify = false;
    	wheelTimer.stop();
    	if (z != 0) {
    	    wheelTimer.start();
    	}
    	
    	String s = getWheel(z);
    	
    	if (s.length() > 0) {
    	    wheel.setText("Wheel: " + s);
    	    notify = true;
    	} else {
    	    wheel.setText("");
    	}
    	
    	visual.processWheel(z);
    	return notify;
    }

    private synchronized void processSync(String type) {
    	syncTimer.stop();
    	
    	if (type  == null) {
    	    sync.setText("");
    	    return;
    	}
    	
    	syncTimer.start();
    	sync.setText("Sync: " + type);
    }
    
    public void actionPerformed(ActionEvent e) {
    	super.actionPerformed(e);
    	if (e.getSource() == wheelTimer) {
    	    processWheel(0);
    	} else if (e.getSource() == syncTimer) {
    	    processSync(null);
    	}
    }
    
    /* implementation of abstract methods */
    String getHeader() {
    	return "Mouse Events";
    }
    
    void addPartLayout() {
    	Panel p = new Panel(new BorderLayout());
    	Panel p1 = new Panel(new BorderLayout());
    	Panel p2 = new Panel(new GridLayout(0, 1, 0, 0));
    	
    	pos = new FixedLabel("  P (8888, 8888)  ", true);
    	p2.add(pos);
    	buttons = new FixedLabel("  L M R  ", true);
    	p2.add(buttons);
    	wheel = new FixedLabel("  Wheel: Down  ", true);
    	p2.add(wheel);
    	sync = new FixedLabel("  Sync: Normal  ", true);
    	p2.add(sync);
    	
    	p1.add(p2, BorderLayout.EAST);
    	p1.add(visual, BorderLayout.CENTER);
    	
    	// avoid stretching
    	p.add(p1, BorderLayout.WEST);
    	p.add(new Label(), BorderLayout.CENTER);
    	
    	add(p, BorderLayout.CENTER);
    	
    	processPos(0, 0, false);
    	processButtons(0);
    	processWheel(0);
    }
    
    private void handlePointerEvent(SasEvent evt) {
    	int x = evt.inputEvent.x;
    	int y = evt.inputEvent.y;
    	int z = evt.inputEvent.z;
    	int b = evt.inputEvent.buttonMask;
    	int t = evt.inputEvent.type;
    	
    	if (t == SasEvent.InputPointerRelative) {
    	    processPos(x, y, true);
    	    //info.newEvent(this, evt, "Mouse Event", "Pos: " + getPos(x, y, true));
    	} else if (z == 0) {
    	    processPos(x, y, false);
    	    //info.newEvent(this, evt, "Mouse Event", "Pos: " + getPos(x, y, false));
    	}
    	
    	if (processWheel(z)) {
    	    info.newEvent(this, evt, "Mouse Wheel Event", "Wheel " + getWheel(z));
    	}
    	
    	int oldB = buttonMask;
    	if (processButtons(b)) {
    	    info.newEvent(this, evt, "Mouse Button Event", getButtonChange(oldB, b));
    	}
    }

    private void handleSyncEvent(SasEvent evt) {
    	processSync(evt.inputEvent.syncType);

    	info.newEvent(this, evt, "Mouse Sync", evt.inputEvent.syncType + " Sync");
    }

    void handlePartSasEvent(SasEvent evt) {
    	if (evt.inputEvent.type == SasEvent.InputMouseSync) {
    	    handleSyncEvent(evt);
    	} else {
    	    handlePointerEvent(evt);
    	}
    }
}
