package nn.pp.sara;

import java.awt.*;
import java.awt.event.*;
import nn.pp.rc.*;

class WarningCanvas extends Canvas {
    Image image;
    Graphics bufferGraphics;
    Image offscreen; 
    boolean showImage = false;
    int w, h, rw, rh;
    int edge = 5;
    
    WarningCanvas(Image image, int w, int h) {
    	this.image = image;
    	this.w = w;
    	this.h = h;
    	rw = w + 2*edge;
    	rh = h + 2*edge;
    }

    public Dimension getMinimumSize() {
    	return new Dimension(rw, rh);
    }
    
    public Dimension getPreferredSize() {
    	return getMinimumSize();
    }
    
    public void update(Graphics g) {
    	paint(g);
    }

    public void paint(Graphics g) {
    	if (bufferGraphics == null) {
    	    offscreen = createImage(rw, rh);
    	    bufferGraphics = offscreen.getGraphics();
    	}
    	bufferGraphics.clearRect(0, 0, rw, rh);
    	if (showImage) {
    	    bufferGraphics.drawImage(image, edge, edge, this);
    	}
    	g.drawImage(offscreen, 0, 0, this);
    }
}

class FixedFatLabel extends FixedLabel {
    FixedFatLabel(String s) {
    	super(s);
    }
    
    private Font font = null;
    
    private void applyFont() {
    	if (font == null) {
    	    Font f = getFont();
    	    if (f == null) return;

    	    font = new Font(f.getName(), f.getStyle() | Font.BOLD, f.getSize());
    	    setFont(font);
    	}
    }
    
    public void paint(Graphics g) {
    	applyFont();
    	super.paint(g);
    }
    
    public void update(Graphics g) {
    	applyFont();
    	super.paint(g);
    }
}

class SecurityPanel extends InfoPanelPart implements ActionListener {
    Label sourceLabel;
    boolean hasSource;
    WarningCanvas warning;
    Label text;
    GenericTimer timer;
    
    SecurityPanel(InfoPanel info) {
    	super(info, true, true);
    	
    	ImageLoader l = new ImageLoader(info.codeBase);
    	Image i = l.loadImage("nn/pp/sara/warning.gif");
    	warning = new WarningCanvas(i, 57, 50);
    	
    	timer = new GenericTimer(20 * 1000, this);
    }
    
    String getHeader() {
    	return "Security Events";
    }
    
    void addPartLayout() {
    	text = new FixedFatLabel("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
    	
    	Panel p = new Panel(new BorderLayout());
    	Panel p1 = new Panel(new BorderLayout());
    	
    	p1.add(warning, BorderLayout.CENTER);
    	p1.add(text, BorderLayout.SOUTH);
    	
    	// avoid stretching
    	p.add(p1, BorderLayout.WEST);
    	p.add(new Label(), BorderLayout.CENTER);

    	add(p, BorderLayout.CENTER);
    }
    
    private void showWarning(boolean show, String text) {
    	timer.stop();
    	if (show) {
    	    timer.start();
    	}

    	if (text == null) text = "";
    	
    	this.text.setText(text);
    	warning.showImage = show;
    	warning.repaint();
    }
    
    public void actionPerformed(ActionEvent e) {
    	super.actionPerformed(e);
    	if (e.getSource() == timer) {
    	    clearSource();
    	    showWarning(false, null);
    	}
    }
    
    private void handleUserLoginFailure(SasEvent evt) {
    	String s = "Username: " + evt.userInfo.user + ", IP: " + evt.userInfo.ip;
    	info.newEvent(this, evt, "Login Failure", s, false);
    	showWarning(true, "Login Failure");
    	
    	// overwrite source labels
    	setUser(evt.userInfo.user);
    	setIp(evt.userInfo.ip);
    }

    void handlePartSasEvent(SasEvent evt) {
    	switch (evt.type) {
    	    case SasEvent.UserLoginFailure:
    	    	handleUserLoginFailure(evt);
    	    	break;
    	}
    }
}
