package nn.pp.sara;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.text.*;
import nn.pp.rc.*;

public class SliderPanel extends Panel implements AdjustmentListener {
    private int sliderMin = 0, sliderMax = 1000, sliderInc = 10;
    private boolean adjusting = false;
    
    ReplayPanel replay;
    FixedLabel timeLabel;
    Scrollbar timeSlider;
    Date currentPos;

    SimpleDateFormat dateFormat;
    Date time1 = new Date(), time2 = new Date();
    
    public SliderPanel(ReplayPanel replay) {
    	this.replay = replay;
    	addLayout();

    	dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }
    
    private void addLayout() {
    	timeLabel = new FixedLabel("  8888-88-88 88:88:88  ");
    	timeSlider = new FixedScrollbar(Scrollbar.HORIZONTAL, 300);
    	timeSlider.addAdjustmentListener(this);
    	timeSlider.setMinimum(sliderMin);
    	timeSlider.setMaximum(sliderMax);
    	timeSlider.setVisibleAmount(1);
    	timeSlider.setPageIncrement(sliderInc);

    	setLayout(new GridLayout(1, 1));
    	
    	Panel p = new Panel();
    	p.setLayout(new BorderLayout());
    	
    	p.add(timeSlider, BorderLayout.CENTER);
    	p.add(timeLabel, BorderLayout.EAST);
    	
    	add(p);
    }
    
    private int getPosFromTime(Date time) {
    	long diffWhole = time2.getTime() - time1.getTime();
    	long diff = time.getTime() - time1.getTime();
    	
    	if (diffWhole == 0) {	// avoid division by 0
    	    return 0;
    	}
    	
    	long pos = ((diff * (sliderMax - sliderMin)) / diffWhole) + sliderMin;
    	
    	return (int) pos;
    }
    
    private Date getTimeFromPos(int pos) {
    	long diffWhole = time2.getTime() - time1.getTime();
    	
    	long t = ((pos - sliderMin) * diffWhole) / (sliderMax - sliderMin) + time1.getTime();
    	
    	return new Date(t);
    }
    
    public void setEnabled(boolean b) {
    	timeLabel.setEnabled(b);
    	timeSlider.setEnabled(b);
    	super.setEnabled(b);
    }
    
    public void adjustmentValueChanged(AdjustmentEvent e) {
    	Object src = e.getSource();
    	
    	if (src == timeSlider) {
    	    if (e.getValueIsAdjusting()) {
    	    	adjusting = true;
    	    } else {
    	    	replay.seek(getTimeFromPos(timeSlider.getValue()));
    	    	adjusting = false;
    	    }
    	}
    }

    synchronized String timeToString(Date time) {
    	return dateFormat.format(time);
    }
    
    Date getCurrentPos() {
    	return currentPos;
    }
    
    void setTime(Date time) {
    	currentPos = time;
    	timeLabel.setText(timeToString(time));
    	if (!adjusting) {
    	    timeSlider.setValue(getPosFromTime(time));
    	}
    }
    
    void setReplayTimes(Date time1, Date time2) {
    	this.time1 = time1;
    	this.time2 = time2;
    }

    void play() {
    	timeSlider.setEnabled(true);
    }
    
    void pause() {
    	timeSlider.setEnabled(false);
    }
    
    void stop() {
    	timeLabel.setText("");
    	timeSlider.setValue(0);
    	timeSlider.setEnabled(false);
    }
}
