#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <pp/um.h>
#include "unblock.h"

#define MAXINPUTSIZE 100
#define SUPER_AUTH_OKAY		0
#define SUPER_AUTH_FAILED	1
#define SUPER_AUTH_BREAK	2

static int show_blocked_users(void);
static int unblock_one_user(void);
static int authenticate_super(void);

int
unblock_users_dialog()
{
    int auth_res;
    int ret = 0;
    
    while ((auth_res = authenticate_super()) == SUPER_AUTH_FAILED);

    if (auth_res == SUPER_AUTH_BREAK) return 0;
    
    while (1) {
	if (!show_blocked_users()) break;
	if (unblock_one_user()) break;
    }
    
    return ret;
}


static
int show_blocked_users(void)
{
    vector_t* users;
    char *p;
    int mins_left, blocked_cnt = 0;
    unsigned int i;
    int ret = -1;

    printf("\nCurrently blocked users:\n\n");
    
    if (NULL != (users = pp_um_get_all_users())) {
	for (i = 0; i < vector_size(users); ++i) {
	    p = (char*)vector_get(users, i);
	    if (pp_um_user_is_blocked(p, &mins_left)) {
		printf("User: %s\t (blocked for ", p);
		if	    (mins_left == 0) printf("< 1 minute)\n");
		else if (mins_left == 1) printf("1 minute)\n");
		else    printf("%d minutes)\n", mins_left);
		blocked_cnt++;
	    }
	}
	vector_delete(users);
    }

    if (blocked_cnt == 0) {
	printf("Currently there are no blocked users\n");
    }
    
    ret = blocked_cnt;

    return ret;
}

static int
authenticate_super(void)
{
    char input[MAXINPUTSIZE];
    char login[MAXINPUTSIZE], *pass;
    int ret, server_sid, gid;
    const char* auth_failed_msg = "Authentication failed. %s\n";

    printf("Please authenticate as superuser.\n\n");
    printf("Login (leave empty to exit): ");
    if (fgets((char*)&input, MAXINPUTSIZE, stdin)) {
	input[strlen(input) - 1] = '\0';
	strncpy(login, input, MAXINPUTSIZE);
    }

    if (strlen(login) == 0) return SUPER_AUTH_BREAK;

    pass = getpass("Password                   : ");

    /* we run locally here, do not check IP for authentication ! */
    if (PP_ERR == pp_um_user_authenticate(login, pass,
                                          PP_UM_AUTH_IGNORE_BLOCKING,
                                          &server_sid, &gid)) {
	printf(auth_failed_msg, errno != PP_UM_ERR_AUTH_FAILED ?
                                pp_error_string(errno) : "");
	ret = SUPER_AUTH_FAILED;
    } else if (PP_FAILED( pp_um_user_has_permission(login, "um", "yes") )) {
	printf("Permission denied.\n");
	ret = SUPER_AUTH_FAILED;
    } else {
	/* unblock super automatically after successful login */
	if (pp_um_user_is_blocked(login, NULL)) {
	    printf("Superuser %s was unblocked automatically.\n", login);
	    pp_um_user_unblock(login);
	}
	ret = SUPER_AUTH_OKAY;
    }
    return ret;
}

static
int unblock_one_user()
{
    char input[MAXINPUTSIZE];
    char user[MAXINPUTSIZE];
    int ret = -1;
    
    printf("\nEnter username to unblock (leave empty to exit): ");
    if (fgets((char*)&input, MAXINPUTSIZE, stdin)) {
	input[strlen(input) - 1] = '\0';
	strncpy(user, input, MAXINPUTSIZE);
    }

    if (strlen(user) == 0) goto bail;

    if (PP_ERR == pp_um_user_unblock(user)) {
	printf("Error unblocking user: %s", pp_error_string(errno));
    }

    ret = 0;
    
 bail:
    return ret;
}
