#!/bin/sh

. /etc/rc.functions
FWUPDSYSDIR=/tmp
echo -n "copy fwupdsys to $FWUPDSYSDIR..."

umount $FWUPDSYSDIR/proc > /dev/null 2>&1
rm -fr $FWUPDSYSDIR/*
mkdir $FWUPDSYSDIR/bin $FWUPDSYSDIR/lib $FWUPDSYSDIR/dev $FWUPDSYSDIR/proc
cp /dev/null /dev/console $FWUPDSYSDIR/dev || exit 1
cp -d /lib/libc.so* /lib/*uClibc* /lib/libcrypt.so* /lib/libcrypt-* /lib/libm*.so* $FWUPDSYSDIR/lib || exit 1
cp /bin/busybox /bin/fwupdate.sh /bin/fldirupdate.sh $FWUPDSYSDIR/bin || exit 1
for f in /bin/* ; do
    if test -h $f && test "`readlink $f`" = "busybox" ; then
	cp -d $f $FWUPDSYSDIR/bin || exit 1
    fi
done

mkdir $FWUPDSYSDIR/lib/webpages
cp /lib/webpages/fwupdated.asp /lib/webpages/style.asp $FWUPDSYSDIR/lib/webpages || exit 1
cp /lib/webpages/button_reset.en.gif $FWUPDSYSDIR/lib/webpages 2> /dev/null

mount proc -t proc $FWUPDSYSDIR/proc
ln -s flashdisk/config $FWUPDSYSDIR/config

cd $FWUPDSYSDIR
if have_nfs_root; then
    mkdir oldroot
    ln -s /oldroot/flashdisk flashdisk
    pivot_root . oldroot || exit 1
else
    mkdir flashdisk
    pivot_root . flashdisk || exit 1
    umount /flashdisk/proc
fi

echo "done"
