#!/bin/sh

# global vars
idx=1

# adds a menu entry
#     $1: symbolic name (alphanumeric and underscores only, no spaces)
#     $2: program to run
#     $3: message to display
add_entry () {
    # mapping: index -> symbolic name  that the user can type
    eval "symname_$idx=$1"
    # reverse mapping: symbolic name -> index
    eval "revname_$1=$idx"
    # mapping: index -> prog to run
    eval "run_$idx=$2"
    # mapping: index -> message
    eval "msg_$idx=\"$3\""

    let "idx=$idx+1"
}

# infinitely loops (read input -> run prog -> ...)
do_loop () {
    while true; do
	# display the menu
	echo -ne "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n"
	echo "Action menu -- select by typing number or name"
	echo "----------------------------------------------"
	i=1
	while [ $i -lt $idx ]; do
	    eval "symname=\$symname_$i"
	    echo "$i) $symname"
	    eval "msg=\$msg_$i"
	    echo "    -> $msg"
	    let "i=$i+1"
	done
	echo "x) exit"
	echo ""
	echo -n "Your choice: "
	read input rest

	# remove special chars
	input=$(echo "$input" | sed -e 's/[^_a-zA-Z0-9]//g')

	# exit
	if [ "$input" = "x" -o "$input" = "exit" ]; then
	    echo "Exiting ..."
	    exit
	fi

	# validate input, map to index
	eval "sel_idx=\$revname_$input"
	if [ -z "$sel_idx" ]; then
	    # not a symbolic name -> check whether it's a valid number
	    if [ "$input" -ge 1 -a "$input" -lt $idx ] 2>/dev/null; then
		sel_idx=$input
	    fi
	fi

	# run selected prog
	if [ -n "$sel_idx" ]; then
	    eval "symname=\$symname_$sel_idx"
	    echo -e "Running '$symname' ...\n"
	    eval "run=\$run_$sel_idx"
	    $run
	else
	    echo Error: "\"$input\" is not a valid entry!"
	fi
    done
}

## main

producttype=`cat /proc/sys/kernel/producttype`

add_entry config  /bin/eric_config  "initial network configuration"
add_entry reset   /bin/reboot.sh    "reset the device"
add_entry ping    /bin/ping.sh      "ping a host"
if [ "$producttype" = "wingle" ]; then
    add_entry wlaninfo /bin/wlan_info.sh "show current WLAN status"
fi

do_loop
