#!/bin/sh

. /etc/rc.functions

eval `echo | get_config <<EOF
eth_interface=
wlan_security_type=
EOF
`
if [ -z $eth_interface ]; then
    echo "No WLAN interface active"
    exit 0
fi

if [ ${eth_interface#eth} = "$eth_interface" ]; then
    wpa_state=`wpa_cli status|grep wpa_state | sed 's/wpa_state=//'`
    ssid=`wpa_cli status|grep '^ssid=' | sed 's/ssid=//'`
    bssid=`wpa_cli status|grep '^bssid=' | sed 's/bssid=//'`
    is_link="no"
    case "$wlan_security_type" in
	WPA)
	    if [ "$wpa_state" = "COMPLETED" ]; then
		echo "Device is associated to access point $ssid ($bssid)."
		echo "WLAN security type is: $wlan_security_type"
		echo "Authentication complete."
		is_link="yes"
	    fi
	    ;;
	none|WEP)
	    if [ "$wpa_state" = "ASSOCIATED" ]; then
		echo "Device is associated to access point $ssid ($bssid)."
		echo "WLAN security type is: $wlan_security_type"
		echo
		if [ "$wlan_security_type" = "WEP" ]; then
		    echo "Note: If still no connection, make sure" \
			"the device and AP use the same WEP key."
		else
		    echo "Note: If still no connection, make sure" \
			"that no WEP key is active on the AP."
		fi
		echo "Make also sure the AP is set to \"open system\"" \
		    "rather than \"shared key\" authentication."
		is_link="yes"
	    fi
	    ;;
    esac
    if [ $is_link = "no" ]; then
	echo "Device is not associated to any access point."
    else
	echo

	freq=`iwlist "$eth_interface" channel |
	    grep "Current Frequency" |
	    sed 's,.*Current Frequency:\(.*\).*,\1,'`
	echo "Current frequency is: $freq"

	SPACETAB=`echo -ne ' \t'`
	qual=`iwconfig "$eth_interface" 2>&1 |
	    grep Quality |
	    sed "s,^[$SPACETAB]*,,"`
	echo "$qual"
	echo

	ip=`ip -4 -o addr show dev "$eth_interface" 2>&1 |
	    head -1 |
	    sed 's,.*inet \([^/ ]*\)[/ ].*,\1,'`
	if [ -n "$ip" ]; then
	    echo "IP address of device: $ip"
	else
	    echo "Device has no IP address."
	fi
    fi
else
    echo "No WLAN interface active"
    exit 0
fi

echo -n "Press <Enter> to continue!"
read dummy
