#!/bin/sh

. /etc/rc.functions

if [ "$2" != "down" -a -f "$1" ]; then
    DHCP_INTERFACE=
    DHCP_IPADDR=
    DHCP_NTPSERVERS=
    eval `cat $1 | sed -e 's,^.*=.*$,DHCP_&,'`
    i=1

    # configure lan interface parameter (speed / duplex mode)
    eric_config -lanif

    # get and configure NTP servers
    for ntp_server in `echo "$DHCP_NTPSERVERS" | sed -e 's|,| |g'`; do
	eval "ntp_server_$i=$ntp_server"
	i=$(($i + 1))
    done

    post_configure_network "$DHCP_INTERFACE" "$DHCP_IPADDR" "$ntp_server_1" "$ntp_server_2"
fi

exit 0
