#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <termios.h>

static int set_serial(int fd);

int
main(int argc, char ** argv)
{
    int fd = -1, ret = 1;
    const char* tty_name;
    
    tty_name = "dev/ttyS0";
    if (argc == 2)
        tty_name = argv[1];

    if((fd = open(tty_name, O_RDWR | O_NDELAY)) < 0) {
	goto bail;
    }

    if (set_serial(fd)) {
	goto bail;
    }

    ret = 0;

 bail:
    if (fd != -1) close(fd);
    return ret;
}


int
set_serial(int fd)    
{
    struct termios tty;

    /* get current settings */
    if (tcgetattr(fd, &tty) < 0) return -1;

    tty.c_cflag = CS8 | HUPCL | CREAD | (speed_t)B115200 | CLOCAL;
    tty.c_iflag = tty.c_lflag = tty.c_oflag = tty.c_line = 0;

    tty.c_iflag |= ICRNL; /* CR->LF in input */
    tty.c_lflag |= ICANON | ISIG | ECHO | ECHOE | ECHOK | ECHOKE;
    tty.c_oflag |= OPOST | ONLCR; /* LF->CR in output */


    /* set new settings*/
    return tcsetattr(fd, TCSANOW, &tty);
}
