#ifndef	_NETINET_IN_H
#define	_NETINET_IN_H	1

#include "glibc-bugs.h"
#include <sys/socket.h>
#include <sys/types.h>
#include <linux/in.h>

#define SOL_IP	0

#ifndef __arm__
/* defining these symbols again results in an "redefined" error message */

# if __BYTE_ORDER == __BIG_ENDIAN
/* The host byte order is the same as network byte order,
 *    so these functions are all just identity.  */
# define ntohl(x)       (x)
# define ntohs(x)       (x)
# define htonl(x)       (x)
# define htons(x)       (x)
# else
#  if __BYTE_ORDER == __LITTLE_ENDIAN
#   include <byteswap.h>
/*
#   define ntohl(x)     __bswap_32 (x)
#   define ntohs(x)     __bswap_16 (x)
#   define htonl(x)     __bswap_32 (x)
#   define htons(x)     __bswap_16 (x)
*/
#  endif
# endif

#endif /* #ifdef __arm__ */

#endif	/* netinet/in.h */
