/****************************************************************************/
/*                                                                          */
/*  Module:        jbiport.h                                                */
/*                                                                          */
/*                 Copyright (C) Altera Corporation 2000-2001               */
/*                                                                          */
/*  Description:   Defines porting macros                                   */
/*                                                                          */
/****************************************************************************/

#ifndef INC_JBIPORT_H
#define INC_JBIPORT_H

#ifndef DEBUGLEVEL
#define DEBUGLEVEL D_NOTICE
#endif

#define D_ALWAYS	0
#define D_ERROR		1
#define D_NOTICE	2
#define D_VERBOSE	3
#define D_BLABLA	4

/*
*  PORT defines the target platform: DOS, WINDOWS, UNIX, or EMBEDDED
*
*  PORT = DOS      means a 16-bit DOS console-mode application
*
*  PORT = WINDOWS  means a 32-bit WIN32 console-mode application for
*                  Windows 95, 98, 2000, ME or NT.  On NT this will use the
*                  DeviceIoControl() API to access the Parallel Port.
*
*  PORT = UNIX     means any UNIX system.  BitBlaster access is support via
*                  the standard ANSI system calls open(), read(), write().
*                  The ByteBlaster is not supported.
*
*  PORT = EMBEDDED means all DOS, WINDOWS, and UNIX code is excluded. 
*                  Remaining code supports 16 and 32-bit compilers. 
*                  Additional porting steps may be necessary. See readme 
*                  file for more details.
*/

#define DOS      2
#define WINDOWS  3
#define UNIX     4
#define EMBEDDED 5
#define JAM_ERLA 6

#ifndef PORT
/* change this line to build a different port */
#define PORT WINDOWS
#endif

#include <stdio.h>

#if PORT == UNIX || PORT == JAM_ERLA

#define D(x, fmt, args...) do { if (x <= DEBUGLEVEL) { printf("jam_stapl: "); printf(fmt, ##args); } } while (0)
#define _D(x, fmt, args...) do { if (x <= DEBUGLEVEL) { printf(fmt, ##args); } } while (0)

#else

#if PORT == WINDOWS
#include <windows.h>
#endif

static void D(int x, char *fmt, ...) {
    if (x <= DEBUGLEVEL) {
	va_list ap;
	va_start(ap, fmt);
	printf("jam_stapl: ");
	vprintf(fmt, ap);
	va_end(ap);
    }
}

static void _D(int x, char *fmt, ...) {
    if (x <= DEBUGLEVEL) {
	va_list ap;
	va_start(ap, fmt);
	vprintf(fmt, ap);
	va_end(ap);
    }
}

#endif

#endif /* INC_JBIPORT_H */
