/**
 * adc_kira.h
 *
 * Kernel module for the ADC on KIRA100
 *
 * (c) 2005 Peppercon AG, Michael Baumann <miba@peppercon.de>
 */

#ifndef _ADC_KIRA_H
#define _ADC_KIRA_H

#include <linux/types.h>

typedef struct {
    uint8_t	channel;
    uint16_t	reading;
} adc_kira_io_t;

#define ADC_KIRA_IOCTL_MAGIC		'A'
#define ADC_KIRA_IOC_GET_READING	_IOWR (ADC_KIRA_IOCTL_MAGIC, 1, adc_kira_io_t)

#endif /* _ADC_KIRA_H */
