/**
 * fml_esb2.h
 *
 * FML TCP Pass Through sideband protocol of
 * Intel ESB2 (Southbridge)
 *
 * (c) 2005 Peppercon AG, 2005/07/21, Ralf Guenther <rgue@peppecon.de>
 */

#ifndef __FML_OPHIR_H__
#define __FML_OPHIR_H__

struct fmlcore_private;

extern int esb2_tpt_blk_lost; // number of lost incoming packets

#define MESB2_MAX_BLK_LEN 1400

int esb2_fml_read_req(struct fmlcore_private *fml, int max_len);
int esb2_fml_stat_req(struct fmlcore_private *fml);
int esb2_fml_reset(struct fmlcore_private *fml);
int esb2_fml_clr_err(struct fmlcore_private *fml);
int esb2_fml_write(struct fmlcore_private *fml, const unsigned char *data, int len);

int esb2_tpt_get_status(struct fmlcore_private *fml,
                        unsigned char chan,
                        unsigned char *pstat,
                        unsigned char *remote_ip);
int esb2_tpt_send(struct fmlcore_private *fml,
                  unsigned char chan,
                  const unsigned char *data,
                  int len);
int esb2_tpt_recv(struct fmlcore_private *fml,
                  unsigned char *pchan,
                  unsigned char *data,
                  int busize);

#endif /* !__FML_OPHIR_H__ */
