/******************************************************************************
 *  MODULE:           FPGA PROTOCOL
 ******************************************************************************
 *
 *  Paragon CIM Firmware Update Header
 *
 *  FILE:             $Workfile$
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential
 * proprietary information distributed solely pursuant to a confidentiality
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _CIM_UPDATE_H_
#define _CIM_UPDATE_H_

/* Device Type String */
#define DCIM_PS2                                       "HKV"
#define DCIM_USB                                       "HKV"
#define DCIM_SUSB                                      "HSU"
#define DCIM_SUN                                       "HSK"
#define P2CIM_PS2                                      "UKV"
#define P2CIM_APS2                                     "UKV"
#define P2CIM_PS2DUAL                                  "UP2"
#define P2CIM_USB                                      "UKV"
#define P2CIM_USBG2                                    "BKS"
#define P2CIM_AUSB                                     "BKS"
#define P2CIM_SUSB                                     "USU"
#define P2CIM_SUN                                      "USK"

/* Device Type expected Packet Size (0xC9) */
/* DCIM */
#define DCIM_PS2_ID_PKT_SIZE                           30
#define DCIM_USB_ID_PKT_SIZE                           30
#define DCIM_SUSB_ID_PKT_SIZE                          30
#define DCIM_SUN_ID_PKT_SIZE                           30
/* P2CIM */
#define P2CIM_PS2_ID_PKT_SIZE                          30
#define P2CIM_APS2_ID_PKT_SIZE                         30
#define P2CIM_PS2DUAL_ID_PKT_SIZE                      30
#define P2CIM_USB_ID_PKT_SIZE                          30
#define P2CIM_USBG2_ID_PKT_SIZE                        27
#define P2CIM_AUSB_ID_PKT_SIZE                         27
#define P2CIM_SUSB_ID_PKT_SIZE                         30
#define P2CIM_SUN_ID_PKT_SIZE                          30
/* SCIM */
#define P2CIM_PWR_ID_PKT_SIZE                          27

/* CIM type ID */
#define CIM_TYPE_DCIM_PS2                              0x01
#define CIM_TYPE_DCIM_USB                              0x02
#define CIM_TYPE_DCIM_SUSB                             0x03
#define CIM_TYPE_DCIM_SUN                              0x04
#define CIM_TYPE_P2CIM_PS2                             0x10
#define CIM_TYPE_P2CIM_APS2                            0x11
#define CIM_TYPE_P2CIM_PS2DUAL                         0x12
#define CIM_TYPE_P2CIM_USB                             0x13
#define CIM_TYPE_P2CIM_USBG2                           0x14
#define CIM_TYPE_P2CIM_AUSB                            0x15
#define CIM_TYPE_P2CIM_SUSB                            0x16
#define CIM_TYPE_P2CIM_SUN                             0x17
#define CIM_TYPE_UKVMPD                                0x20
#define CIM_TYPE_USKVMPD                               0x21
#define CIM_TYPE_UUSBPD                                0x22
#define CIM_TYPE_P2CIM_PWR                             0x30
#define CIM_TYPE_AUATC                                 0x40

#define SERIAL_NUM_LENGTH                              16
#define DEVICE_TYPE_LENGTH                             3
#define HW_VERSION_LENGTH                              2
#define FW_VERSION_LENGTH                              3
#define AUX_VAL_LENGTH                                 3

#define SERIAL_NUM_OFFSET                              1
#define NUM_AUX_VAL_OFFSET                             17
#define DEVICE_TYPE_OFFSET                             18
#define HW_VERSION_OFFSET                              21
#define FW_VERSION_OFFSET                              23
#define AUX_VAL_OFFSET                                 26

#define MAX_BUFFER                                     100
#define NUM_REGIONS                                    1
#define MEM_REC_BUFFER_SIZE                            (64 * 1024)

#define MAX_RESEND                                     5

#define CIM_UPDATE_POLL_TIMEOUT                        (5 * 1000)

#define BLANK                                          " "

/* CIM Update entrance state */
#define CIM_UPDATE_INITIAL_STATE                       0
#define CIM_UPDATE_RECOVERY_STATE                      1

typedef enum
{
    DOWNLOAD = 1,
    PROGRAM_SERIAL_NUM,
    ABORT,
    CHECK_IMAGE,
    RESEND_INFO
} cim_update_init_action_t;

typedef struct 
{
    unsigned char m_Memory[MEM_REC_BUFFER_SIZE];
    int           end_addr;
} cim_update_upper_mem_rec_t;

typedef struct
{
    unsigned char devtype[DEVICE_TYPE_LENGTH+1];
    unsigned char hwver[HW_VERSION_LENGTH+1];
    unsigned char fwver[FW_VERSION_LENGTH+1];
} cim_image_info_t;

extern int cim_update( int fd, int link_if, int state );

#endif /* _CIM_UPDATE_H_ */
