/******************************************************************************
 *  MODULE:           FPGA PROTOCOL
 ******************************************************************************
 *
 *  FPGA Protocol Device Driver Header File
 *
 *  FILE:             $Workfile$
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential
 * proprietary information distributed solely pursuant to a confidentiality
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2005-2006 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _FPD_DRIVER_H_
#define _FPD_DRIVER_H_

#include <linux/spinlock.h>
#include <linux/wait.h>
#include <asm/atomic.h>
#include <linux/pci.h>
#include "fpd_ioctl.h"
#include "fpd_pdata.h"
#include "fpd_host.h"
#include "fpd_lock.h"
#include "fpd_video_switch.h"
#include "fpd_timer.h"
#include "dmabuf.h"


/* default wait time for disconnection */
#define DRIVER_TXBUF_DEFAULT_WAIT_TIME        WAIT_2SEC
#define FPGA_TXBUF_DEFAULT_WAIT_TIME          WAIT_2SEC

typedef struct {
    u32                    link_id;
    u32                    base;
    u32                    target_port;
    u8                     protocol;
    u8                     tx_parity;
    u8                     rx_parity;
    u8                     enabled;
    u8                     inv_cmd[FPD_MAX_INVALID_PARAGON_CMD];
    u8                     inv_cmd_index;
    fpd_lock_t             invcmd_lock;
    fpd_lock_t             echo_rsp;
    fpd_lock_t             error;
    fpd_pdata_t            cim;
    fpd_pdata_t            priority;
    fpd_host_t             host;

    struct task_struct    *tx_thread;   /* Linux task structure of thread */
    struct semaphore       tx_sem;      /* Semaphore for thread control */
    wait_queue_head_t      tx_queue;    /* queue txcim_thread is waiting on */
    atomic_t               req_service;
    atomic_t               close_comm;
    fpd_timer_t            timer;

    void                  *private;
} fpd_linkif_t;

typedef struct fpd_device {
    u32                    id;
    FPD_info_t             info;

    struct pci_dev        *pcidev;
    int                    irq;
    unsigned char         *remap;
    unsigned long          ioaddr;
    unsigned long          iolen;

    fpd_lock_t             switch_lock;  /* all linkif target_port/enabled */
    fpd_lock_t             pci_error;
    fpd_lock_t             event_lock;
    FPD_event_t            event;
    fpd_lock_t             inform_user;
    fpd_lock_t             linestat_lock;
    u32                    line_status_chg[2];

    fpd_linkif_t         **link;
    fpd_linkif_t          *bgnd_link;

    DMA_MEM                dmabuf;

    struct task_struct    *fpd_thread;   /* Linux task structure of thread */
    struct semaphore       fpd_sem;      /* Semaphore for thread control */
    wait_queue_head_t      fpd_queue;    /* queue fpd_thread is waiting on */
    atomic_t               fpd_req;

    wait_queue_head_t      user_wq;

    fpd_vs_t               vs;

    atomic_t               driver_txbuf_wait_time; /* in milliseconds */
    atomic_t               fpga_txbuf_wait_time;   /* in milliseconds */
    atomic_t               cim_detect_event;
    wait_queue_head_t      cim_detect_queue;
} fpd_device_t;


int fpd_driver_ioctl(fpd_device_t *pdev, unsigned int cmd, unsigned long arg);

#endif /* _FPD_DRIVER_H_ */
