/******************************************************************************
 *  MODULE:           FPGA PROTOCOL
 ******************************************************************************
 *
 *  FPGA Protocol Device Driver Paragon (Legacy CIM) Header File
 *
 *  FILE:             $Workfile$
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential
 * proprietary information distributed solely pursuant to a confidentiality
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _FPD_PARAGON_H_
#define _FPD_PARAGON_H_

#include "fpd.h"
#include "fpd_ioctl.h"

extern int fpd_paragon_invalidate_table( fpd_device_t *pfpd, int link_id );
extern int fpd_paragon_write_cmd( fpd_device_t *pfpd, FPD_cmdprog_t *pcmd );
extern int fpd_paragon_read_cmd( fpd_device_t *pfpd, FPD_cmdprog_t *pcmd );
extern int fpd_paragon_handle_invalid_cmd( fpd_linkif_t *plink );
extern int fpd_paragon_get_invalid_cmd( fpd_device_t *pfpd, FPD_rxinvcmd_t *pcmd );
extern int fpd_paragon_handle_echo_rsp( fpd_linkif_t *plink );
extern int fpd_paragon_get_echo_rsp( fpd_device_t *pfpd, FPD_echorsp_t *pcmd );
extern int fpd_paragon_enter_cim_update( fpd_device_t *pfpd, int link_id, u32 chg_mode );
extern int fpd_paragon_exit_cim_update( fpd_device_t *pfpd, int link_id );

#endif /* _FPD_PARAGON_H_ */
