/******************************************************************************
 *  MODULE:           FPGA PROTOCOL
 ******************************************************************************
 *
 *  Simulation of FPGA Protocol CIM/Priority Data Header File
 *
 *  FILE:             $Workfile$
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential
 * proprietary information distributed solely pursuant to a confidentiality
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _FPD_SIMULATE_H_
#define _FPD_SIMULATE_H_

#define FPD_SIMULATED_BUFSIZE                  512

#include "fpd_lock.h"

typedef struct {
    u32                    link_if;
    u32                    btype;
    fpd_lock_t             lock;
    u8                    *buf;
    u8                    *buf_rdptr;
    u8                    *buf_wrptr;
    u8                    *buf_end;
    u32                    buf_bytes_left;
    u32                    status;
    void                  *private;
} fpd_simulate_buf_t;

extern int  fpd_simulate_init( fpd_simulate_buf_t *pcim, u32 link_if, u32 btype, void *parg );
extern int  fpd_simulate_cleanup( fpd_simulate_buf_t *psim );
extern u32  fpd_simulate_read_GISR( fpd_simulate_buf_t *psim );
extern u32  fpd_simulate_read_LIFISR( fpd_simulate_buf_t *psim );
extern u32  fpd_simulate_read_status( fpd_simulate_buf_t *psim );
extern int  fpd_simulate_write( fpd_simulate_buf_t *psim, int len, u8 *appbuf, u32 do_notify );
extern u32  fpd_simulate_read( fpd_simulate_buf_t *psim );

#endif /* _FPD_SIMULATE_H_ */
