/******************************************************************************
 *  MODULE:           FPGA PROTOCOL
 ******************************************************************************
 *
 *  FPGA Protocol Device Driver Video Switch Control Interface Header File
 *
 *  FILE:             $Workfile$
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential
 * proprietary information distributed solely pursuant to a confidentiality
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _FPD_VIDEO_SWITCH_H_
#define _FPD_VIDEO_SWITCH_H_

#include <fpd_ioctl.h>

typedef struct {
    fpd_lock_t             lock;
    u32                    remote_chan;
    u32                    target_port;
    u8                     enabled;
} fpd_rvs_t;

typedef struct {
    fpd_lock_t             lock;
    u32                    video_source;
    u32                    target_port;
    int                    vschip_id;
} fpd_lvs_t;

typedef struct {
    fpd_lvs_t             *local_video;
    fpd_rvs_t            **remote_video;
    FPD_vschip_reg_t     **vschip;
    u32                    remote_cnt;
    u32                    vschip_cnt;
    void                  *private;
} fpd_vs_t;

extern int fpd_vs_init( fpd_vs_t *pvs, void *parg );
extern int fpd_vs_cleanup( fpd_vs_t *pvs );
extern int fpd_vs_write_chip( fpd_vs_t *pvs, u8 chip, u8 reg, u8 data );
extern int fpd_vs_disable( fpd_vs_t *pvs, u32 link_if, u32 remote_chan, u8 locked );
extern int fpd_vs_select( fpd_vs_t *pvs, FPD_video_switch_t *premote );
extern int fpd_vs_local_select( fpd_vs_t *pvs, FPD_local_video_switch_t *plocal );
extern int fpd_vs_get_vschip_contents( fpd_vs_t *pvs, FPD_vschip_contents_t *pchip );

#endif /* _FPD_VIDEO_SWITCH_H_ */
