#ifndef _SMBUS_ARP_H_
#define _SMBUS_ARP_H_

#include <linux/i2c.h>
#include <linux/types.h>
#include <pp_byte_order.h>

#define SMBUS_UDID_ADDR_TYPE_FIXED		0x00
#define SMBUS_UDID_ADDR_TYPE_DYNAMIC_PERSISTENT	0x01
#define SMBUS_UDID_ADDR_TYPE_DYNAMIC_VOLATILE	0x02
#define SMBUS_UDID_ADDR_TYPE_RANDOM		0x03

typedef struct {
    BITFIELD3(	uint8_t,
		pec_supported:	1,
		reserved:	5,
		address_type:	2 );    
} __attribute__((packed)) smbus_udid_caps_t;

typedef struct {
    BITFIELD3(	uint8_t,
		silicon_rev:	3,
		version:	3,
		reserved:	2 );       
} __attribute__((packed)) smbus_udid_version_t;

#define SMBUS_UDID_VERSION_10		0x00
#define SMBUS_UDID_VERSION_11		0x01
/* 0x02, 0x03 reserved */
#define SMBUS_UDID_VERSION_20		0x04

typedef struct {
    BITFIELD5(	uint8_t,
		smbus_version:  4,
		oem:		1,
		asf:		1,
		ipmi:		1,
		reserved:	1 );    
} __attribute__((packed)) smbus_udid_interface_t;

typedef struct {
    smbus_udid_caps_t		caps;
    smbus_udid_version_t	version;
    uint16_t			vendor_id;
    uint16_t			device_id;
    uint8_t			interface_reserved;
    smbus_udid_interface_t	interface;
    uint16_t			subvendor_id;
    uint16_t			subdevice_id;
    uint32_t			specific_id;
} smbus_udid_t;

extern int smbus_arp_trigger(const struct i2c_adapter *adap);
extern int smbus_arp_get_address(const struct i2c_adapter *adap,
				 uint16_t vendor_id, uint16_t device_id);

#endif /* _SMBUS_ARP_H_ */
