/**
 * lpc_smic.h
 *
 * KIRA100 LPC (slave) core driver for System Management Interface Chip protocol
 *
 * (c) 2004 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#ifndef __LPC_SMIC_H__
#define __LPC_BT_H__

#include "lpc_core.h"

int smic_init(lpc_t *lpc, int chan, uint16_t host_io_base, wait_queue_head_t *wait, void **psmic_data);
int smic_cleanup(void *smic_data);

int smic_start(void *smic_data);
int smic_stop(void *smic_data);

int smic_read(void *smic_data, uint8_t *buf, int size);
int smic_write(void *smic_data, const uint8_t *buf, int size);

int smic_can_read(void *smic_data);
int smic_can_write(void *smic_data);

int smic_host_atn(void *smic_data, int set);

int smic_event(void *smic_data);

#endif /* !__LPC_SMIC_H__ */
