/***************************************************************************** 
 * This file contains definitions for the mass storage protocol adapter
 *
 * Copyright (c) 2005 miba@peppercon.de
 ****************************************************************************/

#ifndef _MSP_ADAPTER_H
#define _MSP_ADAPTER_H

typedef enum {
    PP_MSP_READ,
    PP_MSP_WRITE,
    PP_MSP_WRITE_DONE
} pp_msp_scsi_data_cmd_t;

typedef struct {
    u_int32_t dev_no;
    u_int32_t block_length;
    u_int32_t block_count;
} pp_msp_file_info_t;

typedef struct {
    u_int32_t dev_no;
    pp_msp_scsi_data_cmd_t cmd;
    u_int32_t block_length;
    u_int32_t block_address;
    u_int16_t length;
} pp_msp_file_request_t;

typedef struct {
    u_int32_t dev_no;
    u_int8_t response;
    u_int32_t length;
    u_int8_t* data;
} pp_msp_file_response_t;

#define PP_MSP_FILE_DATA_OK		0
#define PP_MSP_FILE_DATA_BAD		1

#define PP_MSP_IOC_GETREQUEST           _IOR ('u',  1, pp_msp_file_request_t)
#define PP_MSP_IOC_SETRESPONSE          _IOW ('u',  2, pp_msp_file_response_t)
#define PP_MSP_IOC_SETFILEINFO		_IOW ('u',  3, pp_msp_file_info_t)

#endif /* _MSP_ADAPTER_H */
