#include <linux/types.h>
#include "pp_usb_ISP1181B.h"

int hal_init(void);
void hal_cleanup(void);

void hal_SetEndpointConfig(uint8_t ep, uint8_t config);
uint8_t hal_GetEndpointConfig(uint8_t ep);

void hal_SetAddressEnable(uint8_t address, uint8_t enable);
uint8_t hal_GetAddress(void);

void hal_SetMode(uint8_t mode);
uint8_t hal_GetMode(void);

void hal_SetDevConfig(uint16_t config);
uint16_t hal_GetDevConfig(void);

void hal_SetIntEnable(uint32_t interrupts);
uint32_t hal_GetIntEnable(void);

void hal_ResetDevice(void);

void hal_WriteEndpoint(uint8_t ep, const uint8_t * buf, uint16_t len);
uint16_t hal_ReadEndpoint(uint8_t ep, uint8_t * buf, uint16_t len);
uint16_t hal_ReadEndpointWOClear(uint8_t ep, uint8_t * buf, uint16_t len);

void hal_SetEndpointStatus(uint8_t ep, uint8_t stalled);
uint8_t hal_GetEndpointStatus(uint8_t ep);
uint8_t hal_GetEndpointStatusWOClear(uint8_t ep);
uint8_t hal_GetEndpointError(uint8_t ep);

void hal_ValidateEndpoint(uint8_t ep);
void hal_ClearEndpoint(uint8_t ep);

void hal_AcknowledgeSetup(void);

void hal_UnlockDevice(uint16_t code);

uint16_t hal_ReadChipID(void);

uint32_t hal_ReadInterruptRegister(void);

void hal_StallEP0InControlWrite(void);
void hal_StallEP0InControlRead(void);

void hal_SingleTransmitEP0(const uint8_t* buf, const uint16_t len);
