#ifndef _MASS_STORAGE_BO_H_
#define _MASS_STORAGE_BO_H_ 1

#include <linux/config.h>
#include <linux/errno.h>
#include <linux/delay.h>
#include <linux/init.h>
#include <linux/ioctl.h>
#include <linux/ioport.h>
#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/module.h>
#include <linux/poll.h>
#include <linux/proc_fs.h>
#include <linux/slab.h>
#include <linux/types.h>
#include <linux/version.h>
#ifdef __powerpc__
#include <asm/time.h>
#endif
#include <linux/rtc.h>

#include <asm/io.h>
#include <asm/irq.h>

#include <kernel_usb.h>

#pragma pack(1)
typedef struct {
    uint8_t data[16];
} cbwcb_t;

typedef struct _COMMAND_BLOCK_WRAPPER{
    uint32_t   dCBWSignature;
    uint32_t   dCBWTag;
    uint32_t   dCBWDataTransferLength;
    uint8_t    bmCBWFlags;
    uint8_t    bCBWLUN;
    uint8_t    bCBWCBLength;
    cbwcb_t    CBWCB;
} cbw_t;

typedef struct _COMMAND_STATUS_WRAPPER{
    uint32_t   dCSWSignature;
    uint32_t   dCSWTag;
    uint32_t   dCSWDataResidue;
    uint8_t    bCSWStatus;
} csw_t;
#pragma pack()

#define MAX_BULKIN_BUFFER (2048)

typedef struct {
    int index;
    struct scsi_s *scsi;
    int ep_in;
    int ep_out;
    
    volatile uint8_t BOTBF_StallAtBulkIn;
    volatile uint8_t BOTBF_StallAtBulkOut;
    volatile int  BOTFSMstate;
    volatile uint8_t DummyRead;

    cbw_t cbw;
    csw_t csw;
    unsigned int cbw_len;

    char* BOTXfer_pData;
    uint32_t BOTXfer_wResidue;
    volatile uint32_t complete_length;
    volatile uint32_t complete_residue;

    uint8_t pDeviceDataBulk[MAX_BULKIN_BUFFER];
    uint8_t file_transfer;
} bot_t;

void ms_bo_handle_classrequest(uint8_t bmRequestType, uint8_t bRequest,
			       uint16_t wValue, uint16_t wIndex, uint16_t wLength);
void ms_bo_data_in_interrupt(uint8_t);
void ms_bo_data_out_interrupt(uint8_t);
void ms_bo_init(void);
void ms_bo_exit(void);
void ms_bo_set_file(int ms_index, uint32_t lba, uint32_t blocklen, usb_device_type_t type, uint8_t readonly);
void ms_bo_unstall_ep_in(uint8_t);
void ms_bo_unstall_ep_out(uint8_t);
uint8_t ms_bo_allow_unstall_ep(uint8_t);
void ms_bo_response(int ms_index, file_response_t* response);

enum _HOST_DEV_DISAGREE {
CASEOK = 0,
CASE1,
CASE2,
CASE3,
CASE4,
CASE5,
CASE6,
CASE7,
CASE8,
CASE9,
CASE10,
CASE11,
CASE12,
CASE13,
CASECMDFAIL
};

#define CSW_GOOD        0x00
#define CSW_FAIL        0x01
#define CSW_PHASE_ERROR 0x02

#define BOTXFER_RAM 0x01
#define BOTXFER_SERIAL 0x02

// FSM for Bulk-Only Transfer

#define USBFSM4BOT_IDLE              0
#define USBFSM4BOT_CBWPROC           1
#define USBFSM4BOT_DATAIN            2
#define USBFSM4BOT_DATAINSENT        3
#define USBFSM4BOT_DATAOUT           4
#define USBFSM4BOT_CSW               5
#define USBFSM4BOT_CSWSTALL          6
#define USBFSM4BOT_CSWSEND           7
#define USBFSM4BOT_CSWSENT           8
#define USBFSM4BOT_RESETRECOVERY     9
#define USBFSM4BOT_WAITFORFILE      10
#define USBFSM4BOT_WAITFORFILEWRITE 11
#define USBFSM4BOT_SENTWAITFORFILE  12

#define EP_MS_BULK_IN(index)	(EP1 + 2 * index)
#define EP_MS_BULK_OUT(index)	(EP2 + 2 * index)

#endif /* #ifndef _MASS_STORAGE_BO_H_ */
