#ifndef __PEPPERCON_USB_H__
#define __PEPPERCON_USB_H__

#include "pp_usb.h"
#include "chap9.h"

int peppercon_usb_init(usb_driver_t *ud, usb_device_mouse_type_t mouse_type, int * enable_mass_storage, usb_device_type_t * mass_storage_types);

#define HID_MOUSE_INT_IN_ENDPOINT       (EP1 + 2 * PP_FEAT_USB_MASS_STORAGE_NO)
#define HID_KEYBOARD_INT_IN_ENDPOINT    (EP2 + 2 * PP_FEAT_USB_MASS_STORAGE_NO)

/* Subclass codes according to USB Mass Storage Specification Overview, 1.2 June 23, 2004 */
#define USB_MASS_STORAGE_SUBCLASS_RBC           0x01
#define USB_MASS_STORAGE_SUBCLASS_SFF8020_MMC2  0x02
#define USB_MASS_STORAGE_SUBCLASS_QIC157        0x03
#define USB_MASS_STORAGE_SUBCLASS_UFI           0x04
#define USB_MASS_STORAGE_SUBCLASS_SFF8070I      0x05
#define USB_MASS_STORAGE_SUBCLASS_SCSI_TRANS_CS 0x06


#endif /* ! __PEPPERCON_USB_H__ */
   
