#ifndef __LARA_USB_ISP1181B_H
#define __LARA_USB_ISP1181B_H

#define ISP1181B_CMD_EP_WRITE_BASE        0x00
#define ISP1181B_CMD_EP_READ_BASE         0x10
#define ISP1181B_CMD_EP_WRITE_CONFIG_BASE 0x20
#define ISP1181B_CMD_EP_READ_CONFIG_BASE  0x30
#define ISP1181B_CMD_EP_EP_STALL_BASE     0x40
#define ISP1181B_CMD_EP_STATUS_BASE       0x50
#define ISP1181B_CMD_EP_VALIDATE_BASE     0x60
#define ISP1181B_CMD_EP_CLEAR_BASE        0x70
#define ISP1181B_CMD_EP_EP_UNSTALL_BASE   0x80

#define ISP1181B_CMD_EP_ERROR_CODE_BASE   0xa0

#define ISP1181B_CMD_UNLOCK_DEVICE        0xb0
#define ISP1181B_CMD_WRITE_SCRATCH        0xb2
#define ISP1181B_CMD_READ_SCRATCH         0xb3
#define ISP1181B_CMD_READ_FRAME_NO        0xb4
#define ISP1181B_CMD_READ_CHIP_ID         0xb5
#define ISP1181B_CMD_WRITE_ADDRESS        0xb6
#define ISP1181B_CMD_READ_ADDRESS         0xb7
#define ISP1181B_CMD_WRITE_MODE           0xb8
#define ISP1181B_CMD_READ_MODE            0xb9

#define ISP1181B_CMD_WRITE_HW_CONFIG      0xba
#define ISP1181B_CMD_READ_HW_CONFIG       0xbb

#define ISP1181B_CMD_READ_INT_STATE       0xc0
#define ISP1181B_CMD_WRITE_INT_ENABLE     0xc2
#define ISP1181B_CMD_READ_INT_ENABLE      0xc3

#define ISP1181B_CMD_EP_CHECK_STATUS_BASE 0xd0

#define ISP1181B_CMD_WRITE_DMA_CONFIG     0xf0
#define ISP1181B_CMD_READ_DMA_CONFIG      0xf1
#define ISP1181B_CMD_WRITE_DMA_COUNTER    0xf2
#define ISP1181B_CMD_READ_DMA_COUNTER     0xf3
#define ISP1181B_CMD_EP_ACK_SETUP         0xf4
/* this should be _only_ used in the kernel module, because of the interrupt problem
   (int polarity is reset on reset of the chip, this could lead to an neverending
   interrupt (interrupt is level triggered))
*/
#define ISP1181B_CMD_RESET                0xf6
/* minimum time (180 ns) for read/write request conforming to ISP manual, Table 59 */
#define ISP1181B_DELAY  210
#define ISP1181B_CHIP_ID                  0x81

#define ISP1181B_HW1_INTPOL   ((0x01) << 0)

#define ISP1181B_INT_IERST    ((0x00000001) << 0)
#define ISP1181B_INT_IERESM   ((0x00000001) << 1)
#define ISP1181B_INT_IESUSP   ((0x00000001) << 2)
#define ISP1181B_INT_IEEOT    ((0x00000001) << 3)
#define ISP1181B_INT_IESOF    ((0x00000001) << 4)
#define ISP1181B_INT_IEPSOF   ((0x00000001) << 5)
#define ISP1181B_INT_SPIEEOT  ((0x00000001) << 6)
#define ISP1181B_INT_BUSSTATE ((0x00000001) << 7) /* cannot be used for INT_ENABLE */
#define ISP1181B_INT_IEP0OUT  ((0x00000001) << 8)
#define ISP1181B_INT_IEP0IN   ((0x00000001) << 9)
#define ISP1181B_INT_IEP1     ((0x00000001) << 10)
#define ISP1181B_INT_IEP2     ((0x00000001) << 11)
#define ISP1181B_INT_IEP3     ((0x00000001) << 12)
#define ISP1181B_INT_IEP4     ((0x00000001) << 13)
#define ISP1181B_INT_IEP5     ((0x00000001) << 14)
#define ISP1181B_INT_IEP6     ((0x00000001) << 15)
#define ISP1181B_INT_IEP7     ((0x00000001) << 16)
#define ISP1181B_INT_IEP8     ((0x00000001) << 17)
#define ISP1181B_INT_IEP9     ((0x00000001) << 18)
#define ISP1181B_INT_IEP10    ((0x00000001) << 19)
#define ISP1181B_INT_IEP11    ((0x00000001) << 20)
#define ISP1181B_INT_IEP12    ((0x00000001) << 21)
#define ISP1181B_INT_IEP13    ((0x00000001) << 22)
#define ISP1181B_INT_IEP14    ((0x00000001) << 23)

#define ISP1181B_INT_IEP(x)   ((0x00000001) << ((x)+8))

#define ISP1181B_INT_N_IEP1      10
#define ISP1181B_INT_N_IEP2      11
#define ISP1181B_INT_N_IEP3      12
#define ISP1181B_INT_N_IEP4      13
#define ISP1181B_INT_N_IEP5      14
#define ISP1181B_INT_N_IEP6      15
#define ISP1181B_INT_N_IEP7      16
#define ISP1181B_INT_N_IEP8      17
#define ISP1181B_INT_N_IEP9      18
#define ISP1181B_INT_N_IEP10     19
#define ISP1181B_INT_N_IEP11     20
#define ISP1181B_INT_N_IEP12     21
#define ISP1181B_INT_N_IEP13     22
#define ISP1181B_INT_N_IEP14     23

#define ISP1181B_INT_N_TO_MASK(n) ((0x00000001) << n)

/* RESERVED                          (0x00000001) << 24
   ...
   RESERVED                          (0x00000001) << 31 */


#define ISP1181B_EP0OUT_FIFO_SIZE 64 /* ISP1181B spec, 9. */
#define ISP1181B_EP0IN_FIFO_SIZE 64

#define EP_OUT 0x00
#define EP_IN 0x80

#define EP0OUT 0x0
#define EP0IN  0x1
#define EP1    0x2
#define EP2    0x3
#define EP3    0x4
#define EP4    0x5
#define EP5    0x6
#define EP6    0x7
#define EP7    0x8
#define EP8    0x9
#define EP9    0xa
#define EP10   0xb
#define EP11   0xc
#define EP12   0xd
#define EP13   0xe
#define EP14   0xf
#define ISP1181B_MAX_EP 16
#define EPNONE ISP1181B_MAX_EP

#define ISP1181B_MODE_SOFTCT         (0x00000001) << 0
/* RESERVED                          (0x00000001) << 1 */
#define ISP1181B_MODE_DBGMOD         (0x00000001) << 2
#define ISP1181B_MODE_INTENA         (0x00000001) << 3
/* RESERVED                          (0x00000001) << 4 */
#define ISP1181B_MODE_GOSUSP         (0x00000001) << 5
/* RESERVED                          (0x00000001) << 6 */
#define ISP1181B_MODE_DMAWD          (0x00000001) << 7

/* RESERVED                          (0x00000001) << 0 */
#define ISP1181B_EP_STATUS_CPUBUF    (0x00000001) << 1
#define ISP1181B_EP_STATUS_SETUPT    (0x00000001) << 2
#define ISP1181B_EP_STATUS_OVERWRITE (0x00000001) << 3
#define ISP1181B_EP_STATUS_DATA_PID  (0x00000001) << 4
#define ISP1181B_EP_STATUS_EPFULL0   (0x00000001) << 5
#define ISP1181B_EP_STATUS_EPFULL1   (0x00000001) << 6
#define ISP1181B_EP_STATUS_EPSTAL    (0x00000001) << 7

#define ISP1181B_EP_CONFIG_FIFOEN    (0x00000001) << 7
#define ISP1181B_EP_CONFIG_EPIN      (0x00000001) << 6
#define ISP1181B_EP_CONFIG_DBLBUF    (0x00000001) << 5
#define ISP1181B_EP_CONFIG_FFOISO    (0x00000001) << 4


#endif /* __LARA_USB_ISP1181B_H */
	  
