/* Ep0 standard request handlers.  These always run in_irq. */

#include <asm/uaccess.h>

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/delay.h>
#include <linux/ioport.h>
#include <linux/sched.h>
#include <linux/slab.h>
#include <linux/smp_lock.h>
#include <linux/errno.h>
#include <linux/init.h>
#include <linux/timer.h>
#include <linux/list.h>
#include <linux/interrupt.h>
#include <linux/uts.h>
#include <linux/version.h>

#include <asm/byteorder.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/system.h>
#include <asm/unaligned.h>

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
# include <linux/device.h>
#endif

#include <linux/usb_ch9.h>
#include <linux/usb_gadget.h>

#include "FTC_zero.h"
#include "chap9.h"

#include "FTC_zero.h"
#include "../lara_common.h"

#define DRV_NAME "ppchap9"


int 
standard_setup_req(struct FTC_zero_dev *ZeroDev,
						const struct usb_ctrlrequest *ctrl)
{
	struct usb_request	*req = ZeroDev->ep0req;
	int value = -EOPNOTSUPP;		// if value>=0, value = "data length of Cx data stage"
	uint8_t recipient;							// else means Cxcmd not support, return stall				
	uint8_t type;							// else means Cxcmd not support, return stall				
	D(D_VERBOSE, "+ (FTC_zero)standard_setup_req()  (ctrl->bRequest = %d)\n",ctrl->bRequest);

	/* Usually this just stores reply data in the pre-allocated ep0 buffer,
	 * but config change events will also reconfigure hardware. */
	
	recipient = (ctrl->bRequestType & USB_RECIP_MASK);
	type = (ctrl->bRequestType & USB_TYPE_MASK);
	
	D(D_VERBOSE, "ctrl-req: Recip: %x, Type: %x, bReq: %x, wIndex: %x, wLength: %x, wValue: %x\n",
		recipient, type, ctrl->bRequest, ctrl->wIndex, ctrl->wLength, ctrl->wValue);
	
	if (recipient == USB_RECIP_INTERFACE) {
		switch (ctrl->bRequest) {
		    case USB_REQ_GET_DESCRIPTOR:
			switch((ctrl->wValue & 0xFF00) >> 8) {
			  case TYPE_REPORT_DESCRIPTOR:
			      if (ctrl->wIndex == ZeroDev->HID_MouseInterfaceNumber) {
				  value = min(ctrl->wLength, (u16)ZeroDev->mouse_hid_desc.w1stDescLength);
				  memcpy(req->buf, ZeroDev->mouse_report_descriptor, value);
			      } else if (ctrl->wIndex == ZeroDev->HID_KeyboardInterfaceNumber) {
				  // keyboard
				  value = min(ctrl->wLength, (u16)sizeof (KeyboardReportDescriptor));
				  memcpy(req->buf, &KeyboardReportDescriptor, value);
			      }
			      break;
			  case TYPE_HID_DESCRIPTOR:
			      if (ctrl->wIndex == ZeroDev->HID_MouseInterfaceNumber) {
				  // mouse
				  value = min(ctrl->wLength, (u16)sizeof (ZeroDev->mouse_hid_desc));
				  memcpy(req->buf, &ZeroDev->mouse_hid_desc, value);
			      } else if (ctrl->wIndex == ZeroDev->HID_KeyboardInterfaceNumber) {
				  // keyboard
				  value = min(ctrl->wLength, (u16)sizeof (ZeroDev->keyboard_hid_desc));
				  memcpy(req->buf, &ZeroDev->keyboard_hid_desc, value);	
			      }
			      break;
			}
			break;
		    case USB_REQ_SET_INTERFACE:
			    if (ctrl->bRequestType != (USB_DIR_OUT| USB_TYPE_STANDARD | USB_RECIP_INTERFACE))
				    break;
			    if (ZeroDev->config && ctrl->wValue == 0) 
			    {
				    /* Raise an exception to wipe out previous transaction
				    * state (queued bufs, etc) and install the new
				    * interface altsetting. */
				    raise_exception(ZeroDev, ZERO_STATE_INTERFACE_CHANGE);
				    value = DELAYED_STATUS;
			    }
			    break;
			    
		    case USB_REQ_GET_INTERFACE:
			    if (ctrl->bRequestType != (USB_DIR_IN | USB_TYPE_STANDARD | USB_RECIP_INTERFACE))
				    break;
			    if (!ZeroDev->config)
				    break;
			    if (ctrl->wValue != 0) 
			    {
				    value = -EDOM;
				    break;
			    }
			    D(D_BLABLA, "get interface\n");
			    *(u8 *) req->buf = 0;
			    value = min(ctrl->wLength, (u16) 1);
			    break;

		      
		    default:
			value = 0;
	    }
	} else { 
	    switch (ctrl->bRequest)
	    {
		    case USB_REQ_GET_DESCRIPTOR:
			    if (ctrl->bRequestType != (USB_DIR_IN | USB_TYPE_STANDARD |	USB_RECIP_DEVICE))
				    break;
			    switch (ctrl->wValue >> 8) 
			    {
				    case USB_DT_DEVICE:
					D(D_VERBOSE, "get device descriptor\n");
					    value = min(ctrl->wLength, (u16) sizeof(ZeroDev->device_desc));
					    memcpy(req->buf, &ZeroDev->device_desc, value);
					    break;
		    #ifdef HIGHSPEED
				    case USB_DT_DEVICE_QUALIFIER:
					D(D_VERBOSE, "get device qualifier\n");
					    value = min(ctrl->wLength, (u16) sizeof(ZeroDev->dev_qualifier));
					    memcpy(req->buf, &ZeroDev->dev_qualifier, value);
					    break;

				    case USB_DT_OTHER_SPEED_CONFIG:
					D(D_VERBOSE, "get other-speed config descriptor\n");
					    goto get_config;
		    #endif /* HIGHSPEED */		
		    
				    case USB_DT_CONFIG:
					D(D_VERBOSE, "get configuration descriptor\n");				
		    #ifdef HIGHSPEED
				    get_config:
		    #endif /* HIGHSPEED */
					    // combine config, interface, and endpoint desc andcopy into req->buf,
					    // and return total desc table length
					    value = populate_config_buf(ZeroDev,
							    ZeroDev->gadget->speed,
							    req->buf,
							    ctrl->wValue >> 8,
							    ctrl->wValue & 0xff);
					    if (value >= 0)
						    value = min(ctrl->wLength, (u16) value);
					    break;

				    case USB_DT_STRING:
					D(D_VERBOSE, "get string descriptor(string 0x%x)\n",(u8)ctrl->wValue);

					    /* wIndex == language code */
					    value = usb_gadget_get_string(&ZeroDev->stringtab,
								    ctrl->wValue & 0xff, req->buf);
					    if (value >= 0)
						    value = min(ctrl->wLength, (u16) value);
					    break;
			    }
			    break;
	    
		    /* One config, two speeds */
		    case USB_REQ_SET_CONFIGURATION:
			    if (ctrl->bRequestType != (USB_DIR_OUT | USB_TYPE_STANDARD |USB_RECIP_DEVICE))
				    break;
			    D(D_VERBOSE, "set configuration\n");
			    if (ctrl->wValue == PP_CONFIG_VALUE || ctrl->wValue == 0) 
			    {
				//    u8CxINVandorDataCount=0;
				    ZeroDev->new_config = ctrl->wValue;

				    /* Raise an exception to wipe out previous transaction
				    * state (queued bufs, etc) and set the new config. */
				    raise_exception(ZeroDev, ZERO_STATE_CONFIG_CHANGE);
				    value = DELAYED_STATUS;
			    }
			    break;
			    
		    case USB_REQ_GET_CONFIGURATION:
			    if (ctrl->bRequestType != (USB_DIR_IN | USB_TYPE_STANDARD |	USB_RECIP_DEVICE))
				    break;
			    D(D_VERBOSE, "get configuration\n");
			    *(u8 *) req->buf = ZeroDev->config;
			    value = min(ctrl->wLength, (u16) 1);
			    break;

		    default:
			D(D_VERBOSE, "unknown control req %02x.%02x v%04x i%04x l%u\n",
				    ctrl->bRequestType, ctrl->bRequest,
				    ctrl->wValue, ctrl->wIndex, ctrl->wLength);
			    break;
	    }
	}
	return value;
}


