/**
 * Description: Button Key parser for generating
 *              java soft keyboard keycodes out of the
 *              Button key description
 *              we assume a en_US kbd layout
 *              keycodes must be delemited by '+'
 */
#define KEYNO		118
#define MAXKEYSYMS	2

const char* keytable[KEYNO][MAXKEYSYMS] = {
    /*   0 */ {"~",            "TILDE"},
    /*   1 */ {"1",            0},
    /*   2 */ {"2",            0},
    /*   3 */ {"3",            0},
    /*   4 */ {"4",            0},
    /*   5 */ {"5",            0},
    /*   6 */ {"6",            0},
    /*   7 */ {"7",            0},
    /*   8 */ {"8",            0},
    /*   9 */ {"9",            0},
    /*  10 */ {"0",            0},
    /*  11 */ {"MINUS",        0},
    /*  12 */ {"=",            "EQUALS"},
    /*  13 */ {"BACK_SPACE",   0},
    /*  14 */ {"TAB",          0},
    /*  15 */ {"Q",            0},
    /*  16 */ {"W",            0},
    /*  17 */ {"E",            0},
    /*  18 */ {"R",            0},
    /*  19 */ {"T",            0},
    /*  20 */ {"Y",            0},
    /*  21 */ {"U",            0},
    /*  22 */ {"I",            0},
    /*  23 */ {"O",            0},
    /*  24 */ {"P",            0},
    /*  25 */ {"[",            0},
    /*  26 */ {"]",            0},
    /*  27 */ {"ENTER",        0},
    /*  28 */ {"CAPS_LOCK",    0},
    /*  29 */ {"A",            0},
    /*  30 */ {"S",            0},
    /*  31 */ {"D",            0},
    /*  32 */ {"F",            0},
    /*  33 */ {"G",            0},
    /*  34 */ {"H",            0},
    /*  35 */ {"J",            0},
    /*  36 */ {"K",            0},
    /*  37 */ {"L",            0},
    /*  38 */ {";",            0},
    /*  39 */ {"'",            0},
    /*  40 */ {"\\",           "BACK_SLASH"},
    /*  41 */ {"LSHIFT",       "SHIFT"},
    /*  42 */ {"<",            "LESS"},
    /*  43 */ {"Z",            0},
    /*  44 */ {"X",            0},
    /*  45 */ {"C",            0},
    /*  46 */ {"V",            0},
    /*  47 */ {"B",            0},
    /*  48 */ {"N",            0},
    /*  49 */ {"M",            0},
    /*  50 */ {",",            0},
    /*  51 */ {".",            0},
    /*  52 */ {"/",            "SLASH"},
    /*  53 */ {"RSHIFT",       0},
    /*  54 */ {"LCTRL",        "CTRL"},
    /*  55 */ {"LALT",         "ALT"},
    /*  56 */ {"SPACE",        0},
    /*  57 */ {"ALTGR",        0},
    /*  58 */ {"RCTRL",        0},
    /*  59 */ {"ESCAPE",       "ESC"},
    /*  60 */ {"F1",           0},
    /*  61 */ {"F2",           0},
    /*  62 */ {"F3",           0},
    /*  63 */ {"F4",           0},
    /*  64 */ {"F5",           0},
    /*  65 */ {"F6",           0},
    /*  66 */ {"F7",           0},
    /*  67 */ {"F8",           0},
    /*  68 */ {"F9",           0},
    /*  69 */ {"F10",          0},
    /*  70 */ {"F11",          0},
    /*  71 */ {"F12",          0},
    /*  72 */ {"PRINTSCREEN",  0},
    /*  73 */ {"SCROLL_LOCK",  0},
    /*  74 */ {"BREAK",        0},
    /*  75 */ {"INSERT",       0},
    /*  76 */ {"HOME",         0},
    /*  77 */ {"PAGE_UP",      0},
    /*  78 */ {"DELETE",       0},
    /*  79 */ {"END",          0},
    /*  80 */ {"PAGE_DOWN",    0},
    /*  81 */ {"UP",           0},
    /*  82 */ {"LEFT",         0},
    /*  83 */ {"DOWN",         0},
    /*  84 */ {"RIGHT",        0},
    /*  85 */ {"NUM_LOCK",     0},
    /*  86 */ {"NUMPAD7",      0},
    /*  87 */ {"NUMPAD8",      0},
    /*  88 */ {"NUMPAD9",      0},
    /*  89 */ {"NUMPADPLUS",   "NUMPAD_PLUS"},
    /*  90 */ {"NUMPAD/",      0},
    /*  91 */ {"NUMPAD4",      0},
    /*  92 */ {"NUMPAD5",      0},
    /*  93 */ {"NUMPAD6",      0},
    /*  94 */ {"NUMPADMUL",    "NUMPAD_MUL"},
    /*  95 */ {"NUMPAD1",      0},
    /*  96 */ {"NUMPAD2",      0},
    /*  97 */ {"NUMPAD3",      0},
    /*  98 */ {"NUMPADENTER",  0},
    /*  99 */ {"NUMPADMINUS",  "NUMPAD_MINUS"},
    /* 100 */ {"NUMPAD0",      0},
    /* 101 */ {"NUMPAD,",      0},
    /* 102 */ {0,              0},
    /* 103 */ {0,              0},
    /* 104 */ {0,              0},
    /* 105 */ {"WINDOWS",      "LWIN"},
    /* 106 */ {"MENU",         "APPS"},
    /* 107 */ {"RWINDOWS",     "RWIN"},
    /* 108 */ {0,              0},
    /* 109 */ {0,              0},
    /* 110 */ {0,              0},
    /* 111 */ {0,              0},
    /* 112 */ {0,              0},
    /* 113 */ {0,              0},
    /* 114 */ {0,              0},
    /* 115 */ {"HANGUL",       0},
    /* 116 */ {"HANJA",        0},
    /* 117 */ {"CANCEL",       0},
};
